/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.ocm.exception.IncorrectAtomicTypeException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverterProvider;

public class AtomicTypeConverterProviderImpl
implements AtomicTypeConverterProvider {
    protected Map m_converters;
    protected Map m_converterInstances = new HashMap();

    public AtomicTypeConverterProviderImpl() {
    }

    public AtomicTypeConverterProviderImpl(Map converters) {
        this.m_converters = converters;
    }

    public void setAtomicTypeConvertors(Map converters) {
        this.m_converters = converters;
    }

    public AtomicTypeConverter getAtomicTypeConverter(Class clazz) {
        AtomicTypeConverter converter = (AtomicTypeConverter)this.m_converterInstances.get(clazz);
        if (null != converter) {
            return converter;
        }
        Class converterClass = (Class)this.m_converters.get(clazz);
        if (null == converterClass) {
            throw new IncorrectAtomicTypeException("No registered converter for a field based on the class :'" + clazz + "'");
        }
        try {
            converter = (AtomicTypeConverter)converterClass.newInstance();
            this.m_converterInstances.put(clazz, converter);
        }
        catch (Exception ex) {
            throw new IncorrectAtomicTypeException("Cannot create converter instance from class '" + clazz + "'", ex);
        }
        return converter;
    }

    public Map getAtomicTypeConverters() {
        HashMap<Class, AtomicTypeConverter> result = new HashMap<Class, AtomicTypeConverter>();
        for (Class clazz : this.m_converters.keySet()) {
            result.put(clazz, this.getAtomicTypeConverter(clazz));
        }
        return result;
    }
}

