/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.jackrabbit.commons.repository.RepositoryFactory;

public class FilterRepositoryFactory
implements RepositoryFactory {
    private final FilterConfig config;

    public FilterRepositoryFactory(FilterConfig config) {
        this.config = config;
    }

    public Repository getRepository() throws RepositoryException {
        ServletContext context;
        Object repository;
        String name = this.config.getInitParameter(Repository.class.getName());
        if (name == null) {
            name = Repository.class.getName();
        }
        if ((repository = (context = this.config.getServletContext()).getAttribute(name)) instanceof Repository) {
            return (Repository)repository;
        }
        if (repository != null) {
            throw new RepositoryException("Invalid repository: Attribute " + name + " in servlet context " + context.getServletContextName() + " is an instance of " + repository.getClass().getName());
        }
        throw new RepositoryException("Repository not found: Attribute " + name + " does not exist in servlet context " + context.getServletContextName());
    }
}

