/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.simple;

import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.simple.DavSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DavSessionProviderImpl
implements DavSessionProvider {
    private static Logger log;
    private final Repository repository;
    private final SessionProvider sesProvider;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.simple.DavSessionProviderImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public DavSessionProviderImpl(Repository rep, SessionProvider sesProvider) {
        this.repository = rep;
        this.sesProvider = sesProvider;
    }

    public boolean attachSession(WebdavRequest request) throws DavException {
        Session repSession;
        block6: {
            String workspaceName = request.getRequestLocator().getWorkspaceName();
            if (workspaceName != null && "".equals(workspaceName)) {
                workspaceName = null;
            }
            if ((repSession = this.sesProvider.getSession((HttpServletRequest)request, this.repository, workspaceName)) != null) break block6;
            log.debug("Could not to retrieve a repository session.");
            return false;
        }
        try {
            DavSessionImpl ds = new DavSessionImpl(repSession);
            log.debug("Attaching session '" + ds + "' to request '" + request + "'");
            request.setDavSession((DavSession)ds);
            return true;
        }
        catch (NoSuchWorkspaceException e) {
            throw new JcrDavException(e, 404);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
        catch (ServletException e) {
            throw new DavException(500, e.getMessage());
        }
    }

    public void releaseSession(WebdavRequest request) {
        DavSession ds = request.getDavSession();
        if (ds != null && ds instanceof DavSessionImpl) {
            Session repSession = ((DavSessionImpl)ds).getRepositorySession();
            String[] lockTokens = repSession.getLockTokens();
            int i = 0;
            while (i < lockTokens.length) {
                repSession.removeLockToken(lockTokens[i]);
                ++i;
            }
            this.sesProvider.releaseSession(repSession);
            log.debug("Releasing session '" + ds + "' from request '" + request + "'");
        }
        request.setDavSession(null);
    }
}

