/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.simple;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import org.apache.jackrabbit.JcrConstants;
import org.apache.jackrabbit.server.io.AbstractExportContext;
import org.apache.jackrabbit.server.io.DefaultIOListener;
import org.apache.jackrabbit.server.io.ExportContext;
import org.apache.jackrabbit.server.io.ExportContextImpl;
import org.apache.jackrabbit.server.io.IOListener;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.server.io.ImportContext;
import org.apache.jackrabbit.server.io.ImportContextImpl;
import org.apache.jackrabbit.server.io.PropertyExportContext;
import org.apache.jackrabbit.server.io.PropertyImportContext;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.jackrabbit.webdav.DavCompliance;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.bind.BindConstants;
import org.apache.jackrabbit.webdav.bind.BindableResource;
import org.apache.jackrabbit.webdav.bind.ParentElement;
import org.apache.jackrabbit.webdav.bind.ParentSet;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.lock.JcrActiveLock;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.SupportedLock;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.apache.jackrabbit.webdav.simple.ItemFilter;
import org.apache.jackrabbit.webdav.simple.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DavResourceImpl
implements DavResource,
BindableResource,
JcrConstants {
    private static final Logger log;
    public static final String METHODS = "OPTIONS, GET, HEAD, POST, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK, BIND, REBIND, UNBIND";
    public static final String COMPLIANCE_CLASSES;
    private DavResourceFactory factory;
    private LockManager lockManager;
    private JcrDavSession session;
    private Node node;
    private DavResourceLocator locator;
    protected DavPropertySet properties = new DavPropertySet();
    protected boolean propsInitialized = false;
    private boolean isCollection = true;
    private String rfc4122Uri;
    private ResourceConfig config;
    private long modificationTime = -1L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.simple.DavResourceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        COMPLIANCE_CLASSES = DavCompliance.concatComplianceClasses((String[])new String[]{"1", "2", "3", "bind"});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DavResourceImpl(DavResourceLocator locator, DavResourceFactory factory, DavSession session, ResourceConfig config) throws DavException {
        JcrDavSession.checkImplementation(session);
        this.session = (JcrDavSession)session;
        this.factory = factory;
        this.locator = locator;
        this.config = config;
        if (locator == null || locator.getRepositoryPath() == null) throw new DavException(404);
        try {
            Item item = this.getJcrSession().getItem(locator.getRepositoryPath());
            if (item == null || !item.isNode()) return;
            this.node = (Node)item;
            this.isCollection = config.isCollectionResource((Item)this.node);
            this.initRfc4122Uri();
            return;
        }
        catch (PathNotFoundException item) {
            return;
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public DavResourceImpl(DavResourceLocator locator, DavResourceFactory factory, DavSession session, ResourceConfig config, boolean isCollection) throws DavException {
        this(locator, factory, session, config, null);
        this.isCollection = isCollection;
    }

    public DavResourceImpl(DavResourceLocator locator, DavResourceFactory factory, DavSession session, ResourceConfig config, Node node) throws DavException {
        if (locator == null || session == null || config == null) {
            throw new IllegalArgumentException();
        }
        JcrDavSession.checkImplementation(session);
        this.session = (JcrDavSession)session;
        this.factory = factory;
        this.locator = locator;
        this.config = config;
        if (locator.getResourcePath() != null) {
            if (node != null) {
                this.node = node;
                this.isCollection = config.isCollectionResource((Item)node);
                this.initRfc4122Uri();
            }
        } else {
            throw new DavException(404);
        }
    }

    private void initRfc4122Uri() {
        try {
            if (this.node.isNodeType("mix:referenceable")) {
                String uuid = this.node.getUUID();
                try {
                    UUID.fromString((String)uuid);
                    this.rfc4122Uri = "urn:uuid:" + uuid;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while detecting UUID", (Throwable)e);
        }
    }

    public String getComplianceClass() {
        return COMPLIANCE_CLASSES;
    }

    public String getSupportedMethods() {
        return METHODS;
    }

    public boolean exists() {
        return this.node != null;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public DavResourceLocator getLocator() {
        return this.locator;
    }

    public String getResourcePath() {
        return this.locator.getResourcePath();
    }

    public String getHref() {
        return this.locator.getHref(this.isCollection());
    }

    public String getDisplayName() {
        String resPath = this.getResourcePath();
        return resPath != null ? Text.getName((String)resPath) : resPath;
    }

    public long getModificationTime() {
        this.initProperties();
        return this.modificationTime;
    }

    public void spool(OutputContext outputContext) throws IOException {
        if (this.exists() && outputContext != null) {
            ExportContext exportCtx = this.getExportContext(outputContext);
            if (!this.config.getIOManager().exportContent(exportCtx, this)) {
                throw new IOException("Unexpected Error while spooling resource.");
            }
        }
    }

    public DavProperty getProperty(DavPropertyName name) {
        this.initProperties();
        return this.properties.get(name);
    }

    public DavPropertySet getProperties() {
        this.initProperties();
        return this.properties;
    }

    public DavPropertyName[] getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    protected void initProperties() {
        Set parentElements;
        if (!this.exists() || this.propsInitialized) {
            return;
        }
        try {
            this.config.getPropertyManager().exportProperties(this.getPropertyExportContext(), this.isCollection());
        }
        catch (RepositoryException e) {
            log.warn("Error while accessing resource properties", (Throwable)e);
        }
        if (this.getDisplayName() != null) {
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getDisplayName()));
        }
        if (this.isCollection()) {
            this.properties.add((DavProperty)new ResourceType(1));
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"1"));
        } else {
            this.properties.add((DavProperty)new ResourceType(0));
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"0"));
        }
        if (this.rfc4122Uri != null) {
            this.properties.add((DavProperty)new HrefProperty(BindConstants.RESOURCEID, this.rfc4122Uri, true));
        }
        if (!(parentElements = this.getParentElements()).isEmpty()) {
            this.properties.add((DavProperty)new ParentSet((Collection)parentElements));
        }
        this.properties.add((DavProperty)new LockDiscovery(this.getLock(Type.WRITE, Scope.EXCLUSIVE)));
        SupportedLock supportedLock = new SupportedLock();
        supportedLock.addEntry(Type.WRITE, Scope.EXCLUSIVE);
        this.properties.add((DavProperty)supportedLock);
        this.propsInitialized = true;
    }

    public void setProperty(DavProperty property) throws DavException {
        this.alterProperty(property);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        this.alterProperty(propertyName);
    }

    private void alterProperty(Object prop) throws DavException {
        if (this.isLocked(this)) {
            throw new DavException(423);
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            ArrayList<Object> l = new ArrayList<Object>(1);
            l.add(prop);
            this.alterProperties(l);
            Map failure = this.config.getPropertyManager().alterProperties(this.getPropertyImportContext(l), this.isCollection());
            if (!failure.isEmpty()) {
                this.node.refresh(false);
                throw new DavException(500);
            }
            this.node.save();
        }
        catch (RepositoryException e) {
            JcrDavException je = new JcrDavException(e);
            try {
                this.node.refresh(false);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            throw je;
        }
    }

    public MultiStatusResponse alterProperties(DavPropertySet setProperties, DavPropertyNameSet removePropertyNames) throws DavException {
        DavPropertyNameIterator it;
        ArrayList<Object> changeList = new ArrayList<Object>();
        if (removePropertyNames != null) {
            it = removePropertyNames.iterator();
            while (it.hasNext()) {
                changeList.add(it.next());
            }
        }
        if (setProperties != null) {
            it = setProperties.iterator();
            while (it.hasNext()) {
                changeList.add(it.next());
            }
        }
        return this.alterProperties(changeList);
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        if (this.isLocked(this)) {
            throw new DavException(423);
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        MultiStatusResponse msr = new MultiStatusResponse(this.getHref(), null);
        try {
            Map failures = this.config.getPropertyManager().alterProperties(this.getPropertyImportContext(changeList), this.isCollection());
            if (failures.isEmpty()) {
                this.node.save();
            } else {
                this.node.refresh(false);
            }
            Iterator it = changeList.iterator();
            while (it.hasNext()) {
                int statusCode;
                Object o = it.next();
                if (failures.containsKey(o)) {
                    Object error = failures.get(o);
                    statusCode = error instanceof RepositoryException ? new JcrDavException((RepositoryException)((Object)error)).getErrorCode() : 500;
                } else {
                    int n = statusCode = failures.isEmpty() ? 200 : 424;
                }
                if (o instanceof DavProperty) {
                    msr.add(((DavProperty)o).getName(), statusCode);
                    continue;
                }
                msr.add((DavPropertyName)o, statusCode);
            }
            return msr;
        }
        catch (RepositoryException e) {
            try {
                this.node.refresh(false);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            throw new JcrDavException(e);
        }
    }

    public DavResource getCollection() {
        DavResource parent = null;
        if (this.getResourcePath() != null && !this.getResourcePath().equals("/")) {
            String parentPath = Text.getRelativeParent((String)this.getResourcePath(), (int)1);
            if (parentPath.equals("")) {
                parentPath = "/";
            }
            DavResourceLocator parentloc = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), this.locator.getWorkspacePath(), parentPath);
            try {
                parent = this.factory.createResource(parentloc, (DavSession)this.session);
            }
            catch (DavException davException) {
                // empty catch block
            }
        }
        return parent;
    }

    public DavResourceIterator getMembers() {
        ArrayList<DavResource> list = new ArrayList<DavResource>();
        if (this.exists() && this.isCollection()) {
            try {
                NodeIterator it = this.node.getNodes();
                while (it.hasNext()) {
                    Node n = it.nextNode();
                    if (!this.isFilteredItem((Item)n)) {
                        DavResourceLocator resourceLocator = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), this.locator.getWorkspacePath(), n.getPath(), false);
                        DavResource childRes = this.factory.createResource(resourceLocator, (DavSession)this.session);
                        list.add(childRes);
                        continue;
                    }
                    log.debug("Filtered resource '" + n.getName() + "'.");
                }
            }
            catch (RepositoryException repositoryException) {
            }
            catch (DavException davException) {
                // empty catch block
            }
        }
        return new DavResourceIteratorImpl(list);
    }

    public void addMember(DavResource member, InputContext inputContext) throws DavException {
        if (!this.exists()) {
            throw new DavException(409);
        }
        if (this.isLocked(this) || this.isLocked(member)) {
            throw new DavException(423);
        }
        try {
            if (this.isFilteredResource(member) || this.node.getDefinition().isProtected()) {
                log.debug("Forbidden to add member: " + member.getDisplayName());
                throw new DavException(403);
            }
            String memberName = Text.getName((String)member.getLocator().getRepositoryPath());
            ImportContext ctx = this.getImportContext(inputContext, memberName);
            if (!this.config.getIOManager().importContent(ctx, member)) {
                throw new DavException(415);
            }
            this.node.save();
        }
        catch (RepositoryException e) {
            log.error("Error while importing resource: " + e.toString());
            throw new JcrDavException(e);
        }
        catch (IOException e) {
            log.error("Error while importing resource: " + e.toString());
            throw new DavException(500, e.getMessage());
        }
    }

    public void removeMember(DavResource member) throws DavException {
        if (!this.exists() || !member.exists()) {
            throw new DavException(404);
        }
        if (this.isLocked(this) || this.isLocked(member)) {
            throw new DavException(423);
        }
        if (this.isFilteredResource(member)) {
            log.debug("Avoid removal of filtered resource: " + member.getDisplayName());
            throw new DavException(403);
        }
        try {
            String itemPath = member.getLocator().getRepositoryPath();
            Item memItem = this.getJcrSession().getItem(itemPath);
            if (memItem instanceof org.apache.jackrabbit.api.jsr283.Node) {
                org.apache.jackrabbit.api.jsr283.Node n = (org.apache.jackrabbit.api.jsr283.Node)memItem;
                n.removeShare();
            } else {
                memItem.remove();
            }
            this.getJcrSession().save();
            try {
                ActiveLock lock;
                if (!this.isJsrLockable() && (lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE)) != null) {
                    this.lockManager.releaseLock(lock.getToken(), member);
                }
            }
            catch (DavException davException) {}
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public void move(DavResource destination) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (this.isLocked(this)) {
            throw new DavException(423);
        }
        if (this.isFilteredResource(destination)) {
            throw new DavException(403);
        }
        this.checkSameWorkspace(destination.getLocator());
        try {
            String destItemPath = destination.getLocator().getRepositoryPath();
            this.getJcrSession().getWorkspace().move(this.locator.getRepositoryPath(), destItemPath);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (this.isLocked(destination)) {
            throw new DavException(423);
        }
        if (this.isFilteredResource(destination)) {
            throw new DavException(403);
        }
        if (shallow && this.isCollection()) {
            throw new DavException(403, "Unable to perform shallow copy.");
        }
        this.checkSameWorkspace(destination.getLocator());
        try {
            String destItemPath = destination.getLocator().getRepositoryPath();
            this.getJcrSession().getWorkspace().copy(this.locator.getRepositoryPath(), destItemPath);
        }
        catch (PathNotFoundException e) {
            throw new DavException(409, e.getMessage());
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public boolean isLockable(Type type, Scope scope) {
        return Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope);
    }

    public boolean hasLock(Type type, Scope scope) {
        return this.getLock(type, scope) != null;
    }

    public ActiveLock getLock(Type type, Scope scope) {
        ActiveLock lock = null;
        if (this.exists() && Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope)) {
            try {
                Lock jcrLock;
                if (this.node.isLocked() && (jcrLock = this.node.getLock()) != null && jcrLock.isLive()) {
                    lock = new JcrActiveLock(jcrLock);
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            if (lock == null) {
                lock = this.lockManager.getLock(type, scope, (DavResource)this);
            }
        }
        return lock;
    }

    public ActiveLock[] getLocks() {
        ActiveLock[] activeLockArray;
        ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (writeLock != null) {
            ActiveLock[] activeLockArray2 = new ActiveLock[1];
            activeLockArray = activeLockArray2;
            activeLockArray2[0] = writeLock;
        } else {
            activeLockArray = new ActiveLock[]{};
        }
        return activeLockArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActiveLock lock(LockInfo lockInfo) throws DavException {
        ActiveLock lock = null;
        if (!this.isLockable(lockInfo.getType(), lockInfo.getScope())) throw new DavException(412, "Unsupported lock type or scope.");
        if (!this.isJsrLockable()) return this.lockManager.createLock(lockInfo, (DavResource)this);
        try {
            Lock jcrLock = this.node.lock(lockInfo.isDeep(), false);
            if (jcrLock == null) return lock;
            return new JcrActiveLock(jcrLock);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public ActiveLock refreshLock(LockInfo lockInfo, String lockToken) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        ActiveLock lock = this.getLock(lockInfo.getType(), lockInfo.getScope());
        if (lock == null) {
            throw new DavException(412, "No lock with the given type/scope present on resource " + this.getResourcePath());
        }
        if (lock instanceof JcrActiveLock) {
            try {
                this.node.getLock().refresh();
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        } else {
            lock = this.lockManager.refreshLock(lockInfo, lockToken, (DavResource)this);
        }
        return lock;
    }

    public void unlock(String lockToken) throws DavException {
        ActiveLock lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (lock == null) {
            throw new DavException(412);
        }
        if (lock.isLockedByToken(lockToken)) {
            if (lock instanceof JcrActiveLock) {
                try {
                    this.node.unlock();
                }
                catch (RepositoryException e) {
                    throw new JcrDavException(e);
                }
            } else {
                this.lockManager.releaseLock(lockToken, (DavResource)this);
            }
        } else {
            throw new DavException(423);
        }
    }

    public void addLockManager(LockManager lockMgr) {
        this.lockManager = lockMgr;
    }

    public DavResourceFactory getFactory() {
        return this.factory;
    }

    public DavSession getSession() {
        return this.session;
    }

    public void bind(DavResource collection, DavResource newBinding) throws DavException {
        if (!this.exists()) {
            throw new DavException(412);
        }
        if (this.isLocked(collection)) {
            throw new DavException(423);
        }
        if (this.isFilteredResource(newBinding)) {
            throw new DavException(403);
        }
        this.checkSameWorkspace(collection.getLocator());
        try {
            if (!this.node.isNodeType("mix:shareable")) {
                if (!this.node.canAddMixin("mix:shareable")) {
                    throw new DavException(412);
                }
                this.node.addMixin("mix:shareable");
                this.node.save();
            }
            Workspace workspace = this.session.getRepositorySession().getWorkspace();
            workspace.clone(workspace.getName(), this.node.getPath(), newBinding.getLocator().getRepositoryPath(), false);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public void rebind(DavResource collection, DavResource newBinding) throws DavException {
        if (!this.exists()) {
            throw new DavException(412);
        }
        if (this.isLocked(this)) {
            throw new DavException(412);
        }
        if (this.isLocked(collection)) {
            throw new DavException(423);
        }
        if (this.isFilteredResource(newBinding)) {
            throw new DavException(403);
        }
        this.checkSameWorkspace(collection.getLocator());
        try {
            if (!this.node.isNodeType("mix:referenceable")) {
                throw new DavException(this.node.canAddMixin("mix:referenceable") ? 409 : 405);
            }
            this.getJcrSession().getWorkspace().move(this.locator.getRepositoryPath(), newBinding.getLocator().getRepositoryPath());
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public Set getParentElements() {
        try {
            if (this.node.getDepth() > 0) {
                if (!(this.node instanceof org.apache.jackrabbit.api.jsr283.Node)) {
                    DavResourceLocator loc = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), this.locator.getWorkspacePath(), this.node.getParent().getPath(), false);
                    return Collections.singleton(new ParentElement(loc.getHref(true), this.node.getName()));
                }
                HashSet<ParentElement> ps = new HashSet<ParentElement>();
                NodeIterator sharedSetIterator = ((org.apache.jackrabbit.api.jsr283.Node)this.node).getSharedSet();
                while (sharedSetIterator.hasNext()) {
                    Node sharednode = sharedSetIterator.nextNode();
                    DavResourceLocator loc = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), this.locator.getWorkspacePath(), sharednode.getParent().getPath(), false);
                    ps.add(new ParentElement(loc.getHref(true), sharednode.getName()));
                }
                return ps;
            }
        }
        catch (RepositoryException e) {
            log.warn("unable to calculate parent set", (Throwable)e);
        }
        return Collections.EMPTY_SET;
    }

    protected Node getNode() {
        return this.node;
    }

    protected ImportContext getImportContext(InputContext inputCtx, String systemId) throws IOException {
        return new ImportContextImpl((Item)this.node, systemId, inputCtx, this.config.getMimeResolver());
    }

    protected ExportContext getExportContext(OutputContext outputCtx) throws IOException {
        return new ExportContextImpl((Item)this.node, outputCtx, this.config.getMimeResolver());
    }

    protected PropertyImportContext getPropertyImportContext(List changeList) {
        return new ProperyImportCtx(changeList);
    }

    protected PropertyExportContext getPropertyExportContext() {
        return new PropertyExportCtx();
    }

    private boolean isJsrLockable() {
        boolean lockable = false;
        if (this.exists()) {
            try {
                lockable = this.node.isNodeType("mix:lockable");
                if (!lockable && this.node.canAddMixin("mix:lockable")) {
                    this.node.addMixin("mix:lockable");
                    this.node.save();
                    lockable = true;
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return lockable;
    }

    private boolean isLocked(DavResource res) {
        ActiveLock lock = res.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (lock == null) {
            return false;
        }
        String[] sLockTokens = this.session.getLockTokens();
        int i = 0;
        while (i < sLockTokens.length) {
            if (sLockTokens[i].equals(lock.getToken())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Session getJcrSession() {
        return this.session.getRepositorySession();
    }

    private boolean isFilteredResource(DavResource resource) {
        ItemFilter filter = this.config.getItemFilter();
        return filter != null && filter.isFilteredItem(resource.getDisplayName(), this.getJcrSession());
    }

    private boolean isFilteredItem(Item item) {
        ItemFilter filter = this.config.getItemFilter();
        return filter != null && filter.isFilteredItem(item);
    }

    private void checkSameWorkspace(DavResourceLocator otherLoc) throws DavException {
        String wspname = this.getJcrSession().getWorkspace().getName();
        if (!wspname.equals(otherLoc.getWorkspaceName())) {
            throw new DavException(403, "Workspace mismatch: expected '" + wspname + "'; found: '" + otherLoc.getWorkspaceName() + "'");
        }
    }

    private class PropertyExportCtx
    extends AbstractExportContext
    implements PropertyExportContext {
        private PropertyExportCtx() {
            super((Item)DavResourceImpl.this.node, false, null);
            this.setCreationTime(-1L);
            this.setModificationTime(-1L);
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public void setContentLanguage(String contentLanguage) {
            if (contentLanguage != null) {
                DavResourceImpl.this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLANGUAGE, (Object)contentLanguage));
            }
        }

        public void setContentLength(long contentLength) {
            if (contentLength > -1L) {
                DavResourceImpl.this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)String.valueOf(contentLength)));
            }
        }

        public void setContentType(String mimeType, String encoding) {
            String contentType = IOUtil.buildContentType(mimeType, encoding);
            if (contentType != null) {
                DavResourceImpl.this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)contentType));
            }
        }

        public void setCreationTime(long creationTime) {
            String created = IOUtil.getCreated(creationTime);
            DavResourceImpl.this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)created));
        }

        public void setModificationTime(long modTime) {
            if (modTime <= -1L) {
                DavResourceImpl.this.modificationTime = new Date().getTime();
            } else {
                DavResourceImpl.this.modificationTime = modTime;
            }
            String lastModified = IOUtil.getLastModified(DavResourceImpl.this.modificationTime);
            DavResourceImpl.this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)lastModified));
        }

        public void setETag(String etag) {
            if (etag != null) {
                DavResourceImpl.this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)etag));
            }
        }

        public void setProperty(Object propertyName, Object propertyValue) {
            if (propertyValue == null) {
                log.warn("Ignore 'setProperty' for " + propertyName + "with null value.");
                return;
            }
            if (propertyValue instanceof DavProperty) {
                DavResourceImpl.this.properties.add((DavProperty)propertyValue);
            } else {
                DavPropertyName pName = propertyName instanceof DavPropertyName ? (DavPropertyName)propertyName : DavPropertyName.create((String)propertyName.toString());
                DavResourceImpl.this.properties.add((DavProperty)new DefaultDavProperty(pName, propertyValue));
            }
        }
    }

    private class ProperyImportCtx
    implements PropertyImportContext {
        private final IOListener ioListener = new DefaultIOListener(DavResourceImpl.access$3());
        private final List changeList;
        private boolean completed;

        private ProperyImportCtx(List changeList) {
            this.changeList = changeList;
        }

        public Item getImportRoot() {
            return DavResourceImpl.this.node;
        }

        public List getChangeList() {
            return Collections.unmodifiableList(this.changeList);
        }

        public IOListener getIOListener() {
            return this.ioListener;
        }

        public boolean hasStream() {
            return false;
        }

        public void informCompleted(boolean success) {
            this.checkCompleted();
            this.completed = true;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        private void checkCompleted() {
            if (this.completed) {
                throw new IllegalStateException("PropertyImportContext has already been consumed.");
            }
        }
    }
}

