/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.version.report;

import java.security.AccessControlException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.jcr.version.report.AbstractJcrReport;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.security.CurrentUserPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.Privilege;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JcrPrivilegeReport
extends AbstractJcrReport {
    private static Logger log;
    private static final String REPORT_NAME = "privileges";
    public static final ReportType PRIVILEGES_REPORT;
    private static final Privilege[] PRIVS;
    private final MultiStatus ms = new MultiStatus();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.version.report.JcrPrivilegeReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.version.report.JcrPrivilegeReport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PRIVILEGES_REPORT = ReportType.register((String)REPORT_NAME, (Namespace)ItemResourceConstants.NAMESPACE, (Class)clazz2);
        PRIVS = new Privilege[]{ItemResourceConstants.PRIVILEGE_JCR_READ, ItemResourceConstants.PRIVILEGE_JCR_ADD_NODE, ItemResourceConstants.PRIVILEGE_JCR_SET_PROPERTY, ItemResourceConstants.PRIVILEGE_JCR_REMOVE};
    }

    public ReportType getType() {
        return PRIVILEGES_REPORT;
    }

    public boolean isMultiStatusReport() {
        return true;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        super.init(resource, info);
        if (!info.containsContentElement("href", DavConstants.NAMESPACE)) {
            throw new DavException(400, "dcr:privileges element must at least contain a single DAV:href child.");
        }
        Element hrefElem = info.getContentElement("href", DavConstants.NAMESPACE);
        String href = DomUtil.getTextTrim((Element)hrefElem);
        DavResourceLocator resourceLoc = resource.getLocator();
        DavResourceLocator loc = resourceLoc.getFactory().createResourceLocator(resourceLoc.getPrefix(), href);
        this.addResponses(loc);
    }

    public Element toXml(Document document) {
        return this.ms.toXml(document);
    }

    private void addResponses(DavResourceLocator locator) {
        String repositoryPath = locator.getRepositoryPath();
        MultiStatusResponse resp = new MultiStatusResponse(locator.getHref(false), null);
        ArrayList<Privilege> currentPrivs = new ArrayList<Privilege>();
        int i = 0;
        while (i < PRIVS.length) {
            try {
                this.getRepositorySession().checkPermission(repositoryPath, PRIVS[i].getName());
                currentPrivs.add(PRIVS[i]);
            }
            catch (AccessControlException e) {
                log.debug(e.toString());
            }
            catch (RepositoryException e) {
                log.debug(e.toString());
            }
            ++i;
        }
        resp.add((DavProperty)new CurrentUserPrivilegeSetProperty(currentPrivs.toArray(new Privilege[currentPrivs.size()])));
        this.ms.addResponse(resp);
    }
}

