/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.search;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.search.SearchResultProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.search.QueryGrammerSet;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.search.SearchResource;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResourceImpl
implements SearchResource {
    private static Logger log;
    private final JcrDavSession session;
    private final DavResourceLocator locator;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.search.SearchResourceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public SearchResourceImpl(DavResourceLocator locator, JcrDavSession session) {
        this.session = session;
        this.locator = locator;
    }

    public QueryGrammerSet getQueryGrammerSet() {
        QueryGrammerSet qgs = new QueryGrammerSet();
        try {
            QueryManager qMgr = this.getRepositorySession().getWorkspace().getQueryManager();
            String[] langs = qMgr.getSupportedQueryLanguages();
            int i = 0;
            while (i < langs.length) {
                qgs.addQueryLanguage(langs[i], Namespace.EMPTY_NAMESPACE);
                ++i;
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return qgs;
    }

    public MultiStatus search(SearchInfo sInfo) throws DavException {
        try {
            Query q = this.getQuery(sInfo);
            QueryResult qR = q.execute();
            return this.queryResultToMultiStatus(qR);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Query getQuery(SearchInfo sInfo) throws InvalidQueryException, RepositoryException, DavException {
        session = this.getRepositorySession();
        nsReg = session.getWorkspace().getNamespaceRegistry();
        rootNode = session.getRootNode();
        qMgr = this.getRepositorySession().getWorkspace().getQueryManager();
        itemPath = this.locator.getRepositoryPath();
        if (itemPath != null && !rootNode.getPath().equals(itemPath) && rootNode.hasNode(qNodeRelPath = itemPath.substring(1)) && (qNode = rootNode.getNode(qNodeRelPath)).isNodeType("nt:query")) {
            return qMgr.getQuery(qNode);
        }
        if (sInfo != null) {
            namespaces = sInfo.getNamespaces();
            try {
                it = namespaces.keySet().iterator();
                while (it.hasNext()) {
                    prefix = (String)it.next();
                    uri = (String)namespaces.get(prefix);
                    session.setNamespacePrefix(prefix, uri);
                }
                q = qMgr.createQuery(sInfo.getQuery(), sInfo.getLanguageName());
            }
            finally {
                it = namespaces.values().iterator();
                ** while (it.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                uri = (String)it.next();
                try {
                    session.setNamespacePrefix(nsReg.getPrefix(uri), uri);
                }
                catch (RepositoryException e) {
                    SearchResourceImpl.log.warn("Unable to reset mapping of namespace: " + uri);
                }
                continue;
lbl29:
                // 1 sources

            }
        } else {
            throw new DavException(400, String.valueOf(this.locator.getResourcePath()) + " is not a nt:query node -> searchRequest body required.");
        }
        if (itemPath != null && !this.getRepositorySession().itemExists(itemPath)) {
            try {
                q.storeAsNode(itemPath);
            }
            catch (RepositoryException e) {
                new JcrDavException(e);
            }
        }
        return q;
    }

    private MultiStatus queryResultToMultiStatus(QueryResult qResult) throws RepositoryException {
        MultiStatus ms = new MultiStatus();
        String[] columnNames = qResult.getColumnNames();
        StringBuffer responseDescription = new StringBuffer();
        String delim = "";
        int i = 0;
        while (i < columnNames.length) {
            responseDescription.append(delim);
            responseDescription.append(ISO9075.encode((String)columnNames[i]));
            delim = " ";
            ++i;
        }
        ms.setResponseDescription(responseDescription.toString());
        RowIterator rowIter = qResult.getRows();
        while (rowIter.hasNext()) {
            Row row = rowIter.nextRow();
            Value[] values = row.getValues();
            String itemPath = row.getValue("jcr:path").getString();
            DavResourceLocator loc = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), this.locator.getWorkspacePath(), itemPath, false);
            String href = loc.getHref(true);
            MultiStatusResponse resp = new MultiStatusResponse(href, null);
            SearchResultProperty srp = new SearchResultProperty(columnNames, values);
            resp.add((DavProperty)srp);
            ms.addResponse(resp);
        }
        return ms;
    }

    private Session getRepositorySession() {
        return this.session.getRepositorySession();
    }
}

