/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.nodetype;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.webdav.jcr.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class PropertyDefinitionImpl
extends ItemDefinitionImpl
implements PropertyDefinition {
    private static Logger log;
    private final int type;
    private final String[] valueConstraints;
    private final Value[] defaultValues;
    private final boolean isMultiple;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.nodetype.PropertyDefinitionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    private PropertyDefinitionImpl(PropertyDefinition definition) {
        super((ItemDefinition)definition);
        this.type = definition.getRequiredType();
        this.valueConstraints = definition.getValueConstraints();
        this.defaultValues = definition.getDefaultValues();
        this.isMultiple = definition.isMultiple();
    }

    public static PropertyDefinitionImpl create(PropertyDefinition definition) {
        if (definition instanceof PropertyDefinitionImpl) {
            return (PropertyDefinitionImpl)definition;
        }
        return new PropertyDefinitionImpl(definition);
    }

    public int getRequiredType() {
        return this.type;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints;
    }

    public Value[] getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public Element toXml(Document document) {
        Element elem = super.toXml(document);
        elem.setAttribute("multiple", Boolean.toString(this.isMultiple()));
        elem.setAttribute("requiredType", PropertyType.nameFromValue((int)this.getRequiredType()));
        Value[] values = this.getDefaultValues();
        if (values != null) {
            Element dvElement = document.createElement("defaultValues");
            int i = 0;
            while (i < values.length) {
                try {
                    Element valElem = document.createElement("defaultValue");
                    DomUtil.setText((Element)valElem, (String)values[i].getString());
                    dvElement.appendChild(valElem);
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
                ++i;
            }
            elem.appendChild(dvElement);
        }
        Element constrElem = document.createElement("valueConstraints");
        String[] constraints = this.getValueConstraints();
        int i = 0;
        while (i < constraints.length) {
            Element vcElem = document.createElement("valueConstraint");
            DomUtil.setText((Element)vcElem, (String)constraints[i]);
            constrElem.appendChild(vcElem);
            ++i;
        }
        elem.appendChild(constrElem);
        return elem;
    }

    String getElementName() {
        return "propertyDefinition";
    }
}

