/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.nodetype;

import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.webdav.jcr.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class NodeDefinitionImpl
extends ItemDefinitionImpl
implements NodeDefinition {
    private static Logger log;
    private final NodeType[] requiredPrimaryTypes;
    private final NodeType defaultPrimaryType;
    private final boolean allowsSameNameSiblings;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.nodetype.NodeDefinitionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    private NodeDefinitionImpl(NodeDefinition definition) {
        super((ItemDefinition)definition);
        this.requiredPrimaryTypes = definition.getRequiredPrimaryTypes();
        this.defaultPrimaryType = definition.getDefaultPrimaryType();
        this.allowsSameNameSiblings = definition.allowsSameNameSiblings();
    }

    public static NodeDefinitionImpl create(NodeDefinition definition) {
        if (definition instanceof NodeDefinitionImpl) {
            return (NodeDefinitionImpl)definition;
        }
        return new NodeDefinitionImpl(definition);
    }

    public NodeType[] getRequiredPrimaryTypes() {
        return this.requiredPrimaryTypes;
    }

    public NodeType getDefaultPrimaryType() {
        return this.defaultPrimaryType;
    }

    public boolean allowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    public Element toXml(Document document) {
        Element elem = super.toXml(document);
        elem.setAttribute("sameNameSiblings", Boolean.toString(this.allowsSameNameSiblings()));
        NodeType defaultPrimaryType = this.getDefaultPrimaryType();
        if (defaultPrimaryType != null) {
            elem.setAttribute("defaultPrimaryType", defaultPrimaryType.getName());
        }
        NodeType[] nts = this.getRequiredPrimaryTypes();
        Element reqPrimaryTypes = document.createElement("requiredPrimaryTypes");
        int i = 0;
        while (i < nts.length) {
            Element rptElem = document.createElement("requiredPrimaryType");
            DomUtil.setText((Element)rptElem, (String)nts[i].getName());
            reqPrimaryTypes.appendChild(rptElem);
            ++i;
        }
        elem.appendChild(reqPrimaryTypes);
        return elem;
    }

    String getElementName() {
        return "childNodeDefinition";
    }
}

