/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.lock;

import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import org.apache.jackrabbit.api.jsr283.Node;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.lock.AbstractActiveLock;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrActiveLock
extends AbstractActiveLock
implements ActiveLock,
DavConstants {
    private static Logger log;
    private final Lock lock;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.webdav.jcr.lock.JcrActiveLock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public JcrActiveLock(Lock lock) {
        if (lock == null) {
            throw new IllegalArgumentException("Can not create a ActiveLock with a 'null' argument.");
        }
        this.lock = lock;
    }

    public boolean isLockedByToken(String lockToken) {
        return lockToken != null && lockToken.equals(this.getToken());
    }

    public boolean isExpired() {
        try {
            return !this.lock.isLive();
        }
        catch (RepositoryException e) {
            log.error("Unexpected error: " + e.getMessage());
            return false;
        }
    }

    public String getToken() {
        String token = this.lock.getLockToken();
        if (token == null && this.lock.isSessionScoped() && this.lock instanceof org.apache.jackrabbit.api.jsr283.lock.Lock && ((org.apache.jackrabbit.api.jsr283.lock.Lock)this.lock).isLockOwningSession()) {
            try {
                token = ((Node)this.lock.getNode()).getIdentifier();
            }
            catch (RepositoryException e) {
                log.warn("Unexpected error while retrieving node identifier for building a DAV specific lock token.", (Object)e.getMessage());
            }
        }
        return token;
    }

    public String getOwner() {
        return this.lock.getLockOwner();
    }

    public void setOwner(String owner) {
        throw new UnsupportedOperationException("setOwner is not implemented");
    }

    public long getTimeout() {
        return Integer.MAX_VALUE;
    }

    public void setTimeout(long timeout) {
        throw new UnsupportedOperationException("setTimeout is not implemented");
    }

    public boolean isDeep() {
        return this.lock.isDeep();
    }

    public void setIsDeep(boolean isDeep) {
        throw new UnsupportedOperationException("setIsDeep is not implemented");
    }

    public Type getType() {
        return Type.WRITE;
    }

    public Scope getScope() {
        return this.lock.isSessionScoped() ? ItemResourceConstants.EXCLUSIVE_SESSION : Scope.EXCLUSIVE;
    }
}

