/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.remoting.davex;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.commons.json.JsonHandler;
import org.apache.jackrabbit.commons.json.JsonParser;
import org.apache.jackrabbit.server.remoting.davex.DiffException;
import org.apache.jackrabbit.server.remoting.davex.DiffHandler;
import org.apache.jackrabbit.server.util.RequestData;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.jcr.JcrValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class JsonDiffHandler
implements DiffHandler {
    private static final Logger log;
    private static final String ORDER_POSITION_AFTER = "#after";
    private static final String ORDER_POSITION_BEFORE = "#before";
    private static final String ORDER_POSITION_FIRST = "#first";
    private static final String ORDER_POSITION_LAST = "#last";
    private final Session session;
    private final ValueFactory vf;
    private final String requestItemPath;
    private final RequestData data;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.server.remoting.davex.JsonDiffHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    JsonDiffHandler(Session session, String requestItemPath, RequestData data) throws RepositoryException {
        this.session = session;
        this.requestItemPath = requestItemPath;
        this.data = data;
        this.vf = session.getValueFactory();
    }

    public void addNode(String targetPath, String diffValue) throws DiffException {
        if (diffValue == null || !diffValue.startsWith("{") || !diffValue.endsWith("}")) {
            throw new DiffException("Invalid 'addNode' value '" + diffValue + "'");
        }
        try {
            String itemPath = this.getItemPath(targetPath);
            String parentPath = Text.getRelativeParent((String)itemPath, (int)1);
            String nodeName = Text.getName((String)itemPath);
            this.addNode(parentPath, nodeName, diffValue);
        }
        catch (RepositoryException e) {
            throw new DiffException(e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String targetPath, String diffValue) throws DiffException {
        try {
            String itemPath = this.getItemPath(targetPath);
            Item item = this.session.getItem(Text.getRelativeParent((String)itemPath, (int)1));
            if (!item.isNode()) {
                throw new DiffException("No such node " + itemPath, (Throwable)new ItemNotFoundException(itemPath));
            }
            Node parent = (Node)item;
            String propName = Text.getName((String)itemPath);
            if ("jcr:mixinTypes".equals(propName)) {
                JsonDiffHandler.setMixins(parent, this.extractValuesFromRequest(targetPath));
                return;
            } else if (diffValue == null || diffValue.length() == 0) {
                Value[] vs = this.extractValuesFromRequest(targetPath);
                if (vs.length == 0) {
                    if (parent.hasProperty(propName)) {
                        parent.getProperty(propName).remove();
                        return;
                    } else {
                        parent.setProperty(propName, null);
                    }
                    return;
                } else {
                    if (vs.length != 1) throw new DiffException("Unexpected number of values in multipart. Was " + vs.length + " but expected 1.");
                    parent.setProperty(propName, vs[0]);
                }
                return;
            } else if (diffValue.startsWith("[") && diffValue.endsWith("]")) {
                if (diffValue.length() == 2) {
                    Value[] vs = this.extractValuesFromRequest(targetPath);
                    parent.setProperty(propName, vs);
                    return;
                } else {
                    Value[] vs = this.extractValues(diffValue);
                    parent.setProperty(propName, vs);
                }
                return;
            } else {
                Value v = this.extractValue(diffValue);
                parent.setProperty(propName, v);
            }
            return;
        }
        catch (RepositoryException e) {
            throw new DiffException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DiffException(e.getMessage(), e);
        }
    }

    public void remove(String targetPath, String diffValue) throws DiffException {
        if (diffValue != null && diffValue.trim().length() != 0) {
            throw new DiffException("'remove' may not have a diffValue.");
        }
        try {
            String itemPath = this.getItemPath(targetPath);
            this.session.getItem(itemPath).remove();
        }
        catch (RepositoryException e) {
            throw new DiffException(e.getMessage(), e);
        }
    }

    public void move(String targetPath, String diffValue) throws DiffException {
        if (diffValue == null || diffValue.length() == 0) {
            throw new DiffException("Invalid 'move' value '" + diffValue + "'");
        }
        try {
            String srcPath = this.getItemPath(targetPath);
            String orderPosition = JsonDiffHandler.getOrderPosition(diffValue);
            if (orderPosition == null) {
                String destPath = this.getItemPath(diffValue);
                this.session.move(srcPath, destPath);
            } else {
                String srcName = Text.getName((String)srcPath);
                int pos = diffValue.lastIndexOf(35);
                String destName = pos == 0 ? null : Text.getName((String)diffValue.substring(0, pos));
                Item item = this.session.getItem(Text.getRelativeParent((String)srcPath, (int)1));
                if (!item.isNode()) {
                    throw new ItemNotFoundException(srcPath);
                }
                Node parent = (Node)item;
                if (ORDER_POSITION_FIRST.equals(orderPosition)) {
                    if (destName != null) {
                        throw new DiffException("#first may not have a leading destination.");
                    }
                    destName = Text.getName((String)parent.getNodes().nextNode().getPath());
                    parent.orderBefore(srcName, destName);
                } else if (ORDER_POSITION_LAST.equals(orderPosition)) {
                    if (destName != null) {
                        throw new DiffException("#last may not have a leading destination.");
                    }
                    parent.orderBefore(srcName, null);
                } else if (ORDER_POSITION_AFTER.equals(orderPosition)) {
                    if (destName == null) {
                        throw new DiffException("#after must have a leading destination.");
                    }
                    NodeIterator it = parent.getNodes();
                    while (it.hasNext()) {
                        Node child = it.nextNode();
                        if (!destName.equals(child.getName())) continue;
                        if (it.hasNext()) {
                            destName = Text.getName((String)it.nextNode().getName());
                            break;
                        }
                        destName = null;
                        break;
                    }
                    parent.orderBefore(srcName, destName);
                } else {
                    parent.orderBefore(srcName, destName);
                }
            }
        }
        catch (RepositoryException e) {
            throw new DiffException(e.getMessage(), e);
        }
    }

    String getItemPath(String diffPath) throws RepositoryException {
        StringBuffer itemPath;
        if (!diffPath.startsWith("/")) {
            itemPath = new StringBuffer(this.requestItemPath);
            if (!this.requestItemPath.endsWith("/")) {
                itemPath.append('/');
            }
            itemPath.append(diffPath);
        } else {
            itemPath = new StringBuffer(diffPath);
        }
        return JsonDiffHandler.normalize(itemPath.toString());
    }

    private void addNode(String parentPath, String nodeName, String diffValue) throws DiffException, RepositoryException {
        Item item = this.session.getItem(parentPath);
        if (!item.isNode()) {
            throw new ItemNotFoundException(parentPath);
        }
        Node parent = (Node)item;
        try {
            NodeHandler hndlr = new NodeHandler(parent, nodeName);
            new JsonParser((JsonHandler)hndlr).parse(diffValue);
        }
        catch (IOException e) {
            throw new DiffException(e.getMessage());
        }
    }

    private static String normalize(String path) {
        if (path.indexOf(46) == -1) {
            return path;
        }
        String[] elems = Text.explode((String)path, (int)47, (boolean)false);
        LinkedList<String> queue = new LinkedList<String>();
        String last = "..";
        int i = 0;
        while (i < elems.length) {
            String segm = elems[i];
            if ("..".equals(segm) && !"..".equals(last)) {
                queue.removeLast();
                last = queue.isEmpty() ? ".." : queue.getLast().toString();
            } else if (!".".equals(segm)) {
                last = segm;
                queue.add(last);
            }
            ++i;
        }
        return "/" + Text.implode((String[])queue.toArray(new String[queue.size()]), (String)"/");
    }

    private static Node importNode(Node parent, String nodeName, String ntName, String uuid) throws RepositoryException {
        String uri = "http://www.jcp.org/jcr/sv/1.0";
        String prefix = "sv:";
        ContentHandler ch = parent.getSession().getImportContentHandler(parent.getPath(), 3);
        try {
            ch.startDocument();
            String nN = "node";
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(uri, "name", String.valueOf(prefix) + "name", "CDATA", nodeName);
            ch.startElement(uri, nN, String.valueOf(prefix) + nN, attrs);
            String pN = "property";
            attrs = new AttributesImpl();
            attrs.addAttribute(uri, "name", String.valueOf(prefix) + "name", "CDATA", "jcr:primaryType");
            attrs.addAttribute(uri, "type", String.valueOf(prefix) + "type", "CDATA", PropertyType.nameFromValue((int)7));
            ch.startElement(uri, pN, String.valueOf(prefix) + pN, attrs);
            ch.startElement(uri, "value", String.valueOf(prefix) + "value", new AttributesImpl());
            char[] val = ntName.toCharArray();
            ch.characters(val, 0, val.length);
            ch.endElement(uri, "value", String.valueOf(prefix) + "value");
            ch.endElement(uri, pN, String.valueOf(prefix) + pN);
            attrs = new AttributesImpl();
            attrs.addAttribute(uri, "name", String.valueOf(prefix) + "name", "CDATA", "jcr:uuid");
            attrs.addAttribute(uri, "type", String.valueOf(prefix) + "type", "CDATA", PropertyType.nameFromValue((int)1));
            ch.startElement(uri, pN, String.valueOf(prefix) + pN, attrs);
            ch.startElement(uri, "value", String.valueOf(prefix) + "value", new AttributesImpl());
            val = uuid.toCharArray();
            ch.characters(val, 0, val.length);
            ch.endElement(uri, "value", String.valueOf(prefix) + "value");
            ch.endElement(uri, pN, String.valueOf(prefix) + pN);
            ch.endElement(uri, nN, String.valueOf(prefix) + nN);
            ch.endDocument();
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
        Node n = null;
        NodeIterator it = parent.getNodes(nodeName);
        while (it.hasNext()) {
            n = it.nextNode();
        }
        if (n == null) {
            throw new RepositoryException("Internal error: No child node added.");
        }
        return n;
    }

    private static void setMixins(Node n, Value[] values) throws RepositoryException {
        if (values.length == 0) {
            NodeType[] mixins = n.getMixinNodeTypes();
            int i = 0;
            while (i < mixins.length) {
                String mixinName = mixins[i].getName();
                n.removeMixin(mixinName);
                ++i;
            }
        } else {
            ArrayList<String> newMixins = new ArrayList<String>(values.length);
            int i = 0;
            while (i < values.length) {
                newMixins.add(values[i].getString());
                ++i;
            }
            NodeType[] mixins = n.getMixinNodeTypes();
            int i2 = 0;
            while (i2 < mixins.length) {
                String mixinName = mixins[i2].getName();
                if (!newMixins.remove(mixinName)) {
                    n.removeMixin(mixinName);
                }
                ++i2;
            }
            Iterator mixIt = newMixins.iterator();
            while (mixIt.hasNext()) {
                n.addMixin(mixIt.next().toString());
            }
        }
    }

    private static String getOrderPosition(String diffValue) {
        String position = null;
        if (diffValue.indexOf(35) > -1 && (diffValue.endsWith(ORDER_POSITION_FIRST) || diffValue.endsWith(ORDER_POSITION_LAST) || diffValue.endsWith(ORDER_POSITION_BEFORE) || diffValue.endsWith(ORDER_POSITION_AFTER))) {
            position = diffValue.substring(diffValue.lastIndexOf(35));
        }
        return position;
    }

    private Value[] extractValuesFromRequest(String paramName) throws RepositoryException, IOException {
        Value[] vs;
        ValueFactory vf = this.session.getValueFactory();
        InputStream[] ins = this.data.getFileParameters(paramName);
        if (ins != null) {
            vs = new Value[ins.length];
            int i = 0;
            while (i < ins.length) {
                vs[i] = vf.createValue(ins[i]);
                ++i;
            }
        } else {
            String[] strs = this.data.getParameterValues(paramName);
            if (strs == null) {
                vs = new Value[]{};
            } else {
                ArrayList<Value> valList = new ArrayList<Value>(strs.length);
                int i = 0;
                while (i < strs.length) {
                    if (strs[i] != null) {
                        int type;
                        String[] types = this.data.getParameterTypes(paramName);
                        int n = type = types == null || types.length <= i ? 0 : JcrValueType.typeFromContentType(types[i]);
                        if (type == 0) {
                            valList.add(vf.createValue(strs[i]));
                        } else {
                            valList.add(vf.createValue(strs[i], type));
                        }
                    }
                    ++i;
                }
                vs = valList.toArray(new Value[valList.size()]);
            }
        }
        return vs;
    }

    private Value extractValue(String diffValue) throws RepositoryException, DiffException, IOException {
        ValueHandler hndlr = new ValueHandler();
        new JsonParser((JsonHandler)hndlr).parse("{\"a\":" + diffValue + "}");
        return hndlr.getValue();
    }

    private Value[] extractValues(String diffValue) throws RepositoryException, DiffException, IOException {
        ValuesHandler hndlr = new ValuesHandler();
        new JsonParser((JsonHandler)hndlr).parse("{\"a\":" + diffValue + "}");
        return hndlr.getValues();
    }

    private abstract class ImportItem {
        final String name;

        private ImportItem(String name) throws IOException {
            if (name == null) {
                throw new IOException("Invalid DIFF format: NULL key.");
            }
            this.name = name;
        }

        abstract void createItem(Node var1) throws RepositoryException;
    }

    private class ImportMvProp
    extends ImportItem {
        private List values;

        private ImportMvProp(String name) throws IOException {
            super(name);
            this.values = new ArrayList();
        }

        void createItem(Node parent) throws RepositoryException {
            Value[] vls = this.values.toArray(new Value[this.values.size()]);
            if ("jcr:mixinTypes".equals(this.name)) {
                JsonDiffHandler.setMixins(parent, vls);
            } else {
                parent.setProperty(this.name, vls);
            }
        }
    }

    private class ImportNode
    extends ImportItem {
        private String ntName;
        private String uuid;
        private List childN;
        private List childP;

        private ImportNode(String name) throws IOException {
            super(name);
            this.childN = new ArrayList();
            this.childP = new ArrayList();
        }

        void addProp(ImportProp prop) {
            if (prop.name.equals("jcr:primaryType")) {
                try {
                    this.ntName = prop.value == null ? null : prop.value.getString();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
            } else if (prop.name.equals("jcr:uuid")) {
                try {
                    this.uuid = prop.value == null ? null : prop.value.getString();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
            } else {
                this.childP.add(prop);
            }
        }

        void addProp(ImportMvProp prop) {
            this.childP.add(prop);
        }

        void addNode(ImportNode node) {
            this.childN.add(node);
        }

        void createItem(Node parent) throws RepositoryException {
            ImportItem obj;
            Node n = this.uuid == null ? (this.ntName == null ? parent.addNode(this.name) : parent.addNode(this.name, this.ntName)) : JsonDiffHandler.importNode(parent, this.name, this.ntName, this.uuid);
            Iterator it = this.childP.iterator();
            while (it.hasNext()) {
                obj = (ImportItem)it.next();
                obj.createItem(n);
            }
            it = this.childN.iterator();
            while (it.hasNext()) {
                obj = (ImportItem)it.next();
                obj.createItem(n);
            }
        }
    }

    private class ImportProp
    extends ImportItem {
        private final Value value;

        private ImportProp(String name, Value v) throws IOException {
            super(name);
            this.value = v;
        }

        void createItem(Node parent) throws RepositoryException {
            parent.setProperty(this.name, this.value);
        }
    }

    private class NodeHandler
    implements JsonHandler {
        private Node parent;
        private String key;
        private Stack st = new Stack();

        private NodeHandler(Node parent, String nodeName) throws IOException {
            this.parent = parent;
            this.key = nodeName;
        }

        public void object() throws IOException {
            ImportNode n = new ImportNode(this.key);
            if (!this.st.isEmpty()) {
                Object obj = this.st.peek();
                if (obj instanceof ImportNode) {
                    ((ImportNode)obj).addNode(n);
                } else {
                    throw new IOException("Invalid DIFF format: The JSONArray may only contain simple values.");
                }
            }
            this.st.push(n);
        }

        public void endObject() throws IOException {
            Object obj = this.st.pop();
            if (!(obj instanceof ImportNode)) {
                throw new IOException("Invalid DIFF format.");
            }
            if (this.st.isEmpty()) {
                try {
                    ((ImportNode)obj).createItem(this.parent);
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                    throw new IOException("Invalid DIFF format");
                }
            }
        }

        public void array() throws IOException {
            ImportMvProp prop = new ImportMvProp(this.key);
            Object obj = this.st.peek();
            if (!(obj instanceof ImportNode)) {
                throw new IOException("Invalid DIFF format: The JSONArray may only contain simple values.");
            }
            ((ImportNode)obj).addProp(prop);
            this.st.push(prop);
        }

        public void endArray() throws IOException {
            Object obj = this.st.pop();
            if (!(obj instanceof ImportMvProp)) {
                throw new IOException("Invalid DIFF format: The JSONArray may only contain simple values.");
            }
        }

        public void key(String key) throws IOException {
            this.key = key;
        }

        public void value(String value) throws IOException {
            Value v = value == null ? null : JsonDiffHandler.this.vf.createValue(value);
            this.value(v);
        }

        public void value(boolean value) throws IOException {
            this.value(JsonDiffHandler.this.vf.createValue(value));
        }

        public void value(long value) throws IOException {
            Value v = JsonDiffHandler.this.vf.createValue(value);
            this.value(v);
        }

        public void value(double value) throws IOException {
            this.value(JsonDiffHandler.this.vf.createValue(value));
        }

        private void value(Value v) throws IOException {
            Object obj = this.st.peek();
            if (obj instanceof ImportMvProp) {
                ((ImportMvProp)obj).values.add(v);
            } else {
                ((ImportNode)obj).addProp(new ImportProp(this.key, v));
            }
        }
    }

    private class ValueHandler
    implements JsonHandler {
        private Value v;

        private ValueHandler() {
        }

        public void object() throws IOException {
        }

        public void endObject() throws IOException {
        }

        public void array() throws IOException {
        }

        public void endArray() throws IOException {
        }

        public void key(String key) throws IOException {
        }

        public void value(String value) throws IOException {
            this.v = value == null ? null : JsonDiffHandler.this.vf.createValue(value);
        }

        public void value(boolean value) throws IOException {
            this.v = JsonDiffHandler.this.vf.createValue(value);
        }

        public void value(long value) throws IOException {
            this.v = JsonDiffHandler.this.vf.createValue(value);
        }

        public void value(double value) throws IOException {
            this.v = JsonDiffHandler.this.vf.createValue(value);
        }

        private Value getValue() {
            return this.v;
        }
    }

    private class ValuesHandler
    implements JsonHandler {
        private List values = new ArrayList();

        private ValuesHandler() {
        }

        public void object() throws IOException {
        }

        public void endObject() throws IOException {
        }

        public void array() throws IOException {
        }

        public void endArray() throws IOException {
        }

        public void key(String key) throws IOException {
        }

        public void value(String value) throws IOException {
            if (value != null) {
                this.values.add(JsonDiffHandler.this.vf.createValue(value));
            } else {
                log.warn("Null element for a multivalued property -> Ignore.");
            }
        }

        public void value(boolean value) throws IOException {
            this.values.add(JsonDiffHandler.this.vf.createValue(value));
        }

        public void value(long value) throws IOException {
            this.values.add(JsonDiffHandler.this.vf.createValue(value));
        }

        public void value(double value) throws IOException {
            this.values.add(JsonDiffHandler.this.vf.createValue(value));
        }

        private Value[] getValues() {
            return this.values.toArray(new Value[this.values.size()]);
        }
    }
}

