/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.benchmark;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigCollectionTest
extends AbstractJCRTest {
    private static final Logger LOG = LoggerFactory.getLogger((Class)BigCollectionTest.class);
    private static int MEMBERS = 500;
    private static int MEMBERSIZE = 1024;
    private static String MIMETYPE = "application/octet-stream";
    private static int MINTIME = 1000;
    private static int MINCOUNT = 5;

    protected void setUp() throws Exception {
        super.setUp();
        Session session = this.testRootNode.getSession();
        Node folder = null;
        try {
            folder = this.testRootNode.getNode("bigcoll");
        }
        catch (RepositoryException ex) {
            // empty catch block
        }
        if (folder != null) {
            folder.remove();
            session.save();
        }
        folder = this.testRootNode.addNode("bigcoll", "nt:folder");
        for (long cnt = 0L; cnt < (long)MEMBERS; ++cnt) {
            BufferedInputStream is = new BufferedInputStream(new ContentGenerator(MEMBERSIZE), MEMBERSIZE);
            Node l_new = folder.addNode("tst" + cnt, "nt:file");
            Node l_cnew = l_new.addNode("jcr:content", "nt:resource");
            l_cnew.setProperty("jcr:data", (InputStream)is);
            l_cnew.setProperty("jcr:mimeType", MIMETYPE);
            l_cnew.setProperty("jcr:lastModified", Calendar.getInstance());
        }
        session.save();
    }

    protected void tearDown() throws Exception {
        try {
            Node folder = this.testRootNode.getNode("bigcoll");
            folder.remove();
            folder.getSession().save();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        super.tearDown();
    }

    private void performTest(String testName, boolean getContentNode, boolean getLength) throws RepositoryException {
        long cnt;
        Session session = this.testRootNode.getSession();
        long start = System.currentTimeMillis();
        for (cnt = 0L; System.currentTimeMillis() - start < (long)MINTIME || cnt < (long)MINCOUNT; ++cnt) {
            Node dir = this.testRootNode.getNode("bigcoll");
            int members = 0;
            NodeIterator it = dir.getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                Node content = getContentNode ? child.getNode("jcr:content") : null;
                String type = getContentNode ? content.getProperty("jcr:mimeType").getString() : null;
                long length = getLength ? content.getProperty("jcr:data").getLength() : -1L;
                BigCollectionTest.assertTrue((boolean)child.isNode());
                if (getContentNode) {
                    BigCollectionTest.assertEquals((String)MIMETYPE, (String)type);
                }
                if (getLength) {
                    BigCollectionTest.assertEquals((long)MEMBERSIZE, (long)length);
                }
                ++members;
            }
            BigCollectionTest.assertEquals((int)MEMBERS, (int)members);
            session.refresh(false);
        }
        long elapsed = System.currentTimeMillis() - start;
        LOG.info(testName + ": " + (double)elapsed / (double)cnt + "ms per call (" + cnt + " iterations)");
    }

    public void testGetChildren() throws RepositoryException {
        this.performTest("testGetChildren", false, false);
    }

    public void testBrowseMinusJcrData() throws RepositoryException {
        this.performTest("testBrowseMinusJcrData", true, false);
    }

    public void testBrowse() throws RepositoryException {
        this.performTest("testBrowse", true, true);
    }

    private class ContentGenerator
    extends InputStream {
        private long length;
        private long position;

        public ContentGenerator(long length) {
            this.length = length;
            this.position = 0L;
        }

        public int read() {
            if (this.position++ < this.length) {
                return 0;
            }
            return -1;
        }
    }
}

