/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PackageDependency;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PackageInfo;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.VersionRange;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class Dependency {
    private String group;
    private String groupId;
    private String name;
    private String artifactId;
    private String version;
    private PackageInfo info;
    private PackageDependency dependency;

    static PackageDependency[] resolve(MavenProject project, Log log, Dependency ... dependencyList) throws IOException {
        PackageDependency[] dependencies = new PackageDependency[dependencyList.length];
        for (int i = 0; i < dependencies.length; ++i) {
            dependencies[i] = dependencyList[i].resolve(project, log);
        }
        return dependencies;
    }

    private PackageDependency resolve(MavenProject project, Log log) throws IOException {
        if (!StringUtils.isEmpty((String)this.group) || !StringUtils.isEmpty((String)this.name)) {
            log.warn((CharSequence)("Using package id in dependencies is deprecated. use maven coordinates instead: " + this.group + ":" + this.name));
        }
        if (!StringUtils.isEmpty((String)this.groupId) && !StringUtils.isEmpty((String)this.artifactId)) {
            for (Artifact a : project.getDependencyArtifacts()) {
                if (!a.getArtifactId().equals(this.artifactId) || !a.getGroupId().equals(this.groupId)) continue;
                PackageInfo info = PackageInfo.read(a.getFile());
                if (info != null) {
                    PackageId id = info.getId();
                    this.group = id.getGroup();
                    this.name = id.getName();
                    if (StringUtils.isEmpty((String)this.version)) {
                        this.version = new VersionRange(id.getVersion(), true, null, false).toString();
                    }
                    this.info = info;
                    break;
                }
                throw new IOException("Specified dependency " + this + " is not a package.");
            }
        }
        if (StringUtils.isEmpty((String)this.group) || StringUtils.isEmpty((String)this.name)) {
            throw new IOException("Specified dependency " + this + " is not qualified.");
        }
        VersionRange range = StringUtils.isEmpty((String)this.version) ? VersionRange.INFINITE : VersionRange.fromString((String)this.version);
        this.dependency = new PackageDependency(this.group, this.name, range);
        return this.dependency;
    }

    @Nullable
    public PackageInfo getInfo() {
        return this.info;
    }

    @Nullable
    public PackageDependency getPackageDependency() {
        return this.dependency;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Dependency{");
        sb.append("group='").append(this.group).append('\'');
        sb.append(", groupId='").append(this.groupId).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", artifactId='").append(this.artifactId).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

