/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.filevault.maven.packaging.PackageId;
import org.apache.jackrabbit.filevault.maven.packaging.impl.DefaultWorkspaceFilter;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PackageType;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PathFilterSet;

public class PackageInfo {
    private final PackageId id;
    private final DefaultWorkspaceFilter filter;
    private final PackageType packageType;

    private PackageInfo(PackageId id, DefaultWorkspaceFilter filter, PackageType packageType) {
        this.id = id;
        this.filter = filter;
        this.packageType = packageType;
    }

    public static PackageInfo read(@Nonnull File file) throws IOException {
        PackageId id = null;
        DefaultWorkspaceFilter filter = null;
        PackageType packageType = PackageType.MIXED;
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements() && (id == null || filter == null)) {
            ZipEntry e = entries.nextElement();
            if ("META-INF/MANIFEST.MF".equalsIgnoreCase(e.getName())) {
                String type;
                Manifest mf = new Manifest(zip.getInputStream(e));
                String idStr = mf.getMainAttributes().getValue("Content-Package-Id");
                if (idStr != null) {
                    id = PackageId.fromString(idStr);
                }
                String roots = mf.getMainAttributes().getValue("Content-Package-Roots");
                filter = new DefaultWorkspaceFilter();
                if (roots != null) {
                    for (String root : StringUtils.split((String)roots, (char)',')) {
                        filter.add(new PathFilterSet(root));
                    }
                }
                if ((type = mf.getMainAttributes().getValue("Content-Package-Type")) == null) continue;
                packageType = PackageType.valueOf(type.toUpperCase());
                continue;
            }
            if ("META-INF/vault/properties.xml".equalsIgnoreCase(e.getName())) {
                Properties props = new Properties();
                props.loadFromXML(zip.getInputStream(e));
                String version = props.getProperty("version");
                if (version == null) {
                    version = "";
                }
                String group = props.getProperty("group");
                String name = props.getProperty("name");
                if (group != null && name != null) {
                    id = new PackageId(group, name, version);
                    continue;
                }
                String path = props.getProperty("path");
                if (path == null || path.length() == 0) {
                    path = "/etc/packages/unknown";
                }
                id = new PackageId(path, version);
                continue;
            }
            if (!"META-INF/vault/filter.xml".equalsIgnoreCase(e.getName())) continue;
            filter = new DefaultWorkspaceFilter();
            filter.load(zip.getInputStream(e));
        }
        zip.close();
        if (id == null || filter == null) {
            return null;
        }
        return new PackageInfo(id, filter, packageType);
    }

    public PackageId getId() {
        return this.id;
    }

    public DefaultWorkspaceFilter getFilter() {
        return this.filter;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }
}

