/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.filevault.maven.packaging.Filter;
import org.apache.jackrabbit.filevault.maven.packaging.impl.DefaultPathFilter;
import org.apache.jackrabbit.filevault.maven.packaging.impl.FilterSet;
import org.apache.jackrabbit.filevault.maven.packaging.impl.ImportMode;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PathFilter;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PathFilterSet;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultWorkspaceFilter {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkspaceFilter.class);
    private final List<PathFilterSet> filterSets = new LinkedList<PathFilterSet>();
    public static final String ATTR_VERSION = "version";
    public static final double SUPPORTED_VERSION = 1.0;
    protected double version = 1.0;
    private byte[] source;
    private PathFilter globalIgnored;

    public void add(PathFilterSet set) {
        this.filterSets.add(set);
    }

    public List<PathFilterSet> getFilterSets() {
        return this.filterSets;
    }

    public PathFilterSet getCoveringFilterSet(String path) {
        if (this.isGloballyIgnored(path)) {
            return null;
        }
        for (PathFilterSet set : this.filterSets) {
            if (!set.covers(path)) continue;
            return set;
        }
        return null;
    }

    public boolean contains(String path) {
        if (this.isGloballyIgnored(path)) {
            return false;
        }
        for (PathFilterSet set : this.filterSets) {
            if (!set.contains(path)) continue;
            return true;
        }
        return false;
    }

    public boolean covers(String path) {
        if (this.isGloballyIgnored(path)) {
            return false;
        }
        for (PathFilterSet set : this.filterSets) {
            if (!set.covers(path)) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestor(String path) {
        for (PathFilterSet set : this.filterSets) {
            if (!set.isAncestor(path)) continue;
            return true;
        }
        return false;
    }

    public boolean isGloballyIgnored(String path) {
        return this.globalIgnored != null && this.globalIgnored.matches(path);
    }

    public void addFilter(Filter filter) {
        this.add(filter.toPathFilterSet());
    }

    public void setFilter(Filter filter) {
        this.add(filter.toPathFilterSet());
    }

    public void load(File file) throws IOException {
        this.load(new FileInputStream(file));
    }

    public InputStream getSource() {
        if (this.source == null) {
            this.generateSource();
        }
        return new ByteArrayInputStream(this.source);
    }

    public String getSourceAsString() {
        if (this.source == null) {
            this.generateSource();
        }
        try {
            return new String(this.source, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void load(InputStream in) throws IOException {
        try {
            this.source = IOUtil.toByteArray((InputStream)in);
            in = this.getSource();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Element doc = document.getDocumentElement();
            if (!"workspaceFilter".equals(doc.getNodeName())) {
                throw new IOException("<workspaceFilter> expected.");
            }
            String v = doc.getAttribute(ATTR_VERSION);
            if (v == null || "".equals(v)) {
                v = "1.0";
            }
            this.version = Double.parseDouble(v);
            if (this.version > 1.0) {
                throw new IOException("version " + this.version + " not supported.");
            }
            this.read(doc);
        }
        catch (ParserConfigurationException e) {
            IOException ioe = new IOException("Unable to create configuration XML parser");
            e.initCause(e);
            throw ioe;
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Configuration file syntax error.");
            e.initCause(e);
            throw ioe;
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    private void read(Element elem) throws IOException {
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            if (!"filter".equals(child.getNodeName())) {
                throw new IOException("<filter> expected.");
            }
            PathFilterSet def = this.readDef((Element)child);
            this.filterSets.add(def);
        }
    }

    private PathFilterSet readDef(Element elem) throws IOException {
        String root = elem.getAttribute("root");
        PathFilterSet def = new PathFilterSet(root == null || root.length() == 0 ? "/" : root);
        String mode = elem.getAttribute("mode");
        if (mode != null && mode.length() > 0) {
            def.setImportMode(ImportMode.valueOf(mode.toUpperCase()));
        }
        def.setCleanUp("cleanup".equals(elem.getAttribute("type")));
        NodeList n1 = elem.getChildNodes();
        for (int i = 0; i < n1.getLength(); ++i) {
            Node child = n1.item(i);
            if (child.getNodeType() != 1) continue;
            if ("include".equals(child.getNodeName())) {
                def.addInclude(this.readFilter((Element)child));
                continue;
            }
            if ("exclude".equals(child.getNodeName())) {
                def.addExclude(this.readFilter((Element)child));
                continue;
            }
            throw new IOException("either <include> or <exclude> expected.");
        }
        return def;
    }

    private PathFilter readFilter(Element elem) throws IOException {
        String pattern = elem.getAttribute("pattern");
        if (pattern == null || "".equals(pattern)) {
            throw new IOException("Filter pattern must not be empty");
        }
        return new DefaultPathFilter(pattern);
    }

    public void generateSource() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MXSerializer ser = new MXSerializer();
            ser.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"    ");
            ser.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
            ser.setOutput((OutputStream)out, "UTF-8");
            ser.startDocument("UTF-8", null);
            ser.text("\n");
            ser.startTag(null, "workspaceFilter");
            ser.attribute(null, ATTR_VERSION, String.valueOf(this.version));
            for (PathFilterSet set : this.filterSets) {
                ser.startTag(null, "filter");
                ser.attribute(null, "root", set.getRoot());
                if (set.isCleanUp()) {
                    ser.attribute(null, "type", "cleanup");
                }
                if (set.getImportMode() != ImportMode.REPLACE) {
                    ser.attribute(null, "mode", set.getImportMode().name().toLowerCase());
                }
                for (FilterSet.Entry entry : set.getEntries()) {
                    PathFilter filter = (PathFilter)entry.getFilter();
                    if (filter instanceof DefaultPathFilter) {
                        if (entry.isInclude()) {
                            ser.startTag(null, "include");
                            ser.attribute(null, "pattern", ((DefaultPathFilter)filter).getPattern());
                            ser.endTag(null, "include");
                            continue;
                        }
                        ser.startTag(null, "exclude");
                        ser.attribute(null, "pattern", ((DefaultPathFilter)filter).getPattern());
                        ser.endTag(null, "exclude");
                        continue;
                    }
                    throw new IllegalArgumentException("Can only export default path filters, yet.");
                }
                ser.endTag(null, "filter");
            }
            ser.endTag(null, "workspaceFilter");
            ser.endDocument();
            this.source = out.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setGlobalIgnored(PathFilter ignored) {
        this.globalIgnored = ignored;
    }

    public void merge(DefaultWorkspaceFilter source) {
        for (PathFilterSet fs : source.getFilterSets()) {
            for (PathFilterSet mfs : this.getFilterSets()) {
                if (!mfs.getRoot().equals(fs.getRoot())) continue;
                throw new IllegalArgumentException("Merging of equal filter roots not allowed for: " + fs.getRoot());
            }
            this.add(fs);
        }
    }
}

