/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import org.apache.jackrabbit.filevault.maven.packaging.IncludeExcludeList;
import org.apache.jackrabbit.filevault.maven.packaging.impl.DefaultPathFilter;
import org.apache.jackrabbit.filevault.maven.packaging.impl.ImportMode;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PathFilterSet;

public class Filter {
    static final String INDENT = "    ";
    private String root;
    private ImportMode mode = ImportMode.REPLACE;
    private boolean cleanupType;
    private final IncludeExcludeList includes = new IncludeExcludeList();
    private final IncludeExcludeList excludes = new IncludeExcludeList();

    public Filter() {
    }

    public Filter(String root) {
        this.setRoot(root);
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getRoot() {
        return this.root;
    }

    public void setMode(String mode) {
        if (mode != null) {
            this.mode = ImportMode.valueOf(mode.toUpperCase());
        }
    }

    public ImportMode getMode() {
        return this.mode;
    }

    public boolean isCleanupType() {
        return this.cleanupType;
    }

    public void setType(String type) {
        this.cleanupType = "cleanup".equals(type);
    }

    public PathFilterSet toPathFilterSet() {
        PathFilterSet set = new PathFilterSet();
        set.setRoot(this.root);
        set.setImportMode(this.mode);
        set.setCleanUp(this.cleanupType);
        for (String pattern : this.includes) {
            set.addInclude(new DefaultPathFilter(pattern));
        }
        for (String pattern : this.excludes) {
            set.addExclude(new DefaultPathFilter(pattern));
        }
        return set;
    }
}

