/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.mapper.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.ocm.exception.IncorrectPersistentClassException;
import org.apache.jackrabbit.ocm.exception.InitMapperException;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.mapper.DescriptorReader;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.MappingDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapperImpl
implements Mapper {
    protected static final Logger log = LoggerFactory.getLogger(AbstractMapperImpl.class);
    protected DescriptorReader descriptorReader;
    protected MappingDescriptor mappingDescriptor;
    protected Collection rootClassDescriptors = new ArrayList();

    public void buildMapper() {
        this.mappingDescriptor = this.descriptorReader.loadClassDescriptors();
        this.mappingDescriptor.setMapper(this);
        if (null != this.mappingDescriptor) {
            List errors = new ArrayList();
            errors = this.solveReferences(errors);
            if (!(errors = this.validateDescriptors(errors, this.rootClassDescriptors)).isEmpty()) {
                throw new InitMapperException("Mapping descriptors contain errors." + this.getErrorMessage(errors));
            }
        } else {
            throw new InitMapperException("No mappings were provided");
        }
    }

    protected List solveReferences(List errors) {
        for (Map.Entry entry : this.mappingDescriptor.getClassDescriptorsByClassName().entrySet()) {
            ClassDescriptor cd = (ClassDescriptor)entry.getValue();
            if (null != cd.getExtend() && !"".equals(cd.getExtend())) {
                ClassDescriptor superClassDescriptor = this.mappingDescriptor.getClassDescriptorByName(cd.getExtend());
                if (null == superClassDescriptor) {
                    log.debug("Cannot find mapping for class " + cd.getExtend() + " referenced as extends from " + cd.getClassName());
                    cd.setExtend(null);
                } else {
                    log.debug("Class " + cd.getClassName() + " extends " + cd.getExtend());
                    cd.setSuperClassDescriptor(superClassDescriptor);
                }
            } else {
                this.rootClassDescriptors.add(cd);
            }
            Set interfaces = cd.getImplements();
            HashSet<String> mappedInterfaces = new HashSet<String>();
            if (interfaces.size() <= 0) continue;
            for (String interfaceName : interfaces) {
                ClassDescriptor interfaceClassDescriptor = this.mappingDescriptor.getClassDescriptorByName(interfaceName);
                if (null == interfaceClassDescriptor) {
                    log.debug("Cannot find mapping for interface " + interfaceName + " referenced as implements from " + cd.getClassName());
                    continue;
                }
                log.debug("Class " + cd.getClassName() + " implements " + interfaceName);
                interfaceClassDescriptor.addDescendantClassDescriptor(cd);
                mappedInterfaces.add(interfaceName);
            }
            cd.setImplements(mappedInterfaces);
        }
        return errors;
    }

    protected List validateDescriptors(List errors, Collection classDescriptors) {
        for (ClassDescriptor classDescriptor : classDescriptors) {
            try {
                classDescriptor.afterPropertiesSet();
                if (!classDescriptor.hasDescendants()) continue;
                errors = this.validateDescriptors(errors, classDescriptor.getDescendantClassDescriptors());
            }
            catch (JcrMappingException jme) {
                log.warn("Mapping of class " + classDescriptor.getClassName() + " is invalid", (Throwable)jme);
                errors.add(jme.getMessage());
            }
        }
        return errors;
    }

    protected String getErrorMessage(List errors) {
        String lineSep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        Iterator it = errors.iterator();
        while (it.hasNext()) {
            buf.append(lineSep).append(it.next());
        }
        return buf.toString();
    }

    public ClassDescriptor getClassDescriptorByClass(Class clazz) {
        ClassDescriptor descriptor = this.mappingDescriptor.getClassDescriptorByName(clazz.getName());
        if (descriptor == null) {
            throw new IncorrectPersistentClassException("Class of type: " + clazz.getName() + " has no descriptor.");
        }
        return descriptor;
    }

    public ClassDescriptor getClassDescriptorByNodeType(String jcrNodeType) {
        ClassDescriptor descriptor = this.mappingDescriptor.getClassDescriptorByNodeType(jcrNodeType);
        if (descriptor == null) {
            throw new IncorrectPersistentClassException("Node type: " + jcrNodeType + " has no descriptor.");
        }
        return descriptor;
    }
}

