/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.impl;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;

public class ObjectIterator
implements RangeIterator {
    private NodeIterator nodeIterator;
    private Session session;
    private ObjectConverter objectConverter;

    public ObjectIterator(NodeIterator iterator, ObjectConverter converter, Session session) {
        this.nodeIterator = iterator;
        this.objectConverter = converter;
        this.session = session;
    }

    public boolean hasNext() {
        return this.nodeIterator.hasNext();
    }

    public Object next() {
        try {
            Node node = this.nodeIterator.nextNode();
            return this.objectConverter.getObject(this.session, node.getPath());
        }
        catch (RepositoryException re) {
            throw new org.apache.jackrabbit.ocm.exception.RepositoryException("Repository access issue trying to map node to an object", re);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skip(long l) {
        this.nodeIterator.skip(l);
    }

    public long getSize() {
        return this.nodeIterator.getSize();
    }

    public long getPosition() {
        return this.nodeIterator.getPosition();
    }
}

