/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.collectionconverter.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableCollection;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableMap;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjectsUtil;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;

public class ResidualPropertiesCollectionConverterImpl
extends AbstractCollectionConverterImpl {
    public ResidualPropertiesCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        this.internalSetProperties(session, parentNode, collectionDescriptor, objects, false);
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        this.internalSetProperties(session, parentNode, collectionDescriptor, objects, true);
    }

    protected ManageableObjects doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        try {
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            PropertyIterator pi = parentNode.getProperties(jcrName);
            if (!pi.hasNext()) {
                return null;
            }
            ManageableObjects objects = ManageableObjectsUtil.getManageableObjects(collectionFieldClass);
            AtomicTypeConverter atomicTypeConverter = this.getAtomicTypeConverter(collectionDescriptor);
            while (pi.hasNext()) {
                String name;
                ArrayList<Object> value;
                Property prop = pi.nextProperty();
                if (prop.getDefinition().isProtected()) continue;
                if (prop.getDefinition().isMultiple()) {
                    ArrayList<Object> valueList = new ArrayList<Object>();
                    Value[] values = prop.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        valueList.add(atomicTypeConverter.getObject(values[i]));
                    }
                    value = valueList;
                } else {
                    value = atomicTypeConverter.getObject(prop.getValue());
                }
                if (objects instanceof Map) {
                    name = prop.getName();
                    ((Map)((Object)objects)).put(name, value);
                    continue;
                }
                if (objects instanceof ManageableCollection) {
                    ((ManageableCollection)objects).addObject(value);
                    continue;
                }
                name = prop.getName();
                ((ManageableMap)objects).addObject(name, value);
            }
            return objects;
        }
        catch (ValueFormatException vfe) {
            throw new ObjectContentManagerException("Cannot get the collection field : " + collectionDescriptor.getFieldName() + "for class " + collectionDescriptor.getClassDescriptor().getClassName(), vfe);
        }
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        return parentNode == null || !parentNode.getProperties(jcrName).hasNext();
    }

    private void internalSetProperties(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects, boolean removeExisting) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        if (!(objects instanceof ManageableMap)) {
            return;
        }
        if (removeExisting) {
            PropertyIterator pi = parentNode.getProperties(jcrName);
            while (pi.hasNext()) {
                Property prop = pi.nextProperty();
                if (prop.getDefinition().isProtected()) continue;
                prop.remove();
            }
        }
        AtomicTypeConverter atomicTypeConverter = this.getAtomicTypeConverter(collectionDescriptor);
        try {
            Map map = (Map)objects.getObjects();
            ValueFactory valueFactory = session.getValueFactory();
            for (Map.Entry entry : map.entrySet()) {
                String name = String.valueOf(entry.getKey());
                if (parentNode.hasProperty(name) && parentNode.getProperty(name).getDefinition().isProtected()) continue;
                Object value2 = entry.getValue();
                if (value2 instanceof List) {
                    List valueList = (List)value2;
                    Value[] jcrValues = new Value[valueList.size()];
                    int i = 0;
                    for (Object value2 : valueList) {
                        jcrValues[i++] = atomicTypeConverter.getValue(valueFactory, value2);
                    }
                    parentNode.setProperty(name, jcrValues);
                    continue;
                }
                Value jcrValue = atomicTypeConverter.getValue(valueFactory, value2);
                parentNode.setProperty(name, jcrValue);
            }
        }
        catch (ValueFormatException vfe) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), vfe);
        }
    }

    private AtomicTypeConverter getAtomicTypeConverter(CollectionDescriptor collectionDescriptor) {
        String elementClassName = collectionDescriptor.getElementClassName();
        Class elementClass = ReflectionUtils.forName(elementClassName);
        AtomicTypeConverter atc = (AtomicTypeConverter)this.atomicTypeConverters.get(elementClass);
        if (atc != null) {
            return atc;
        }
        throw new ObjectContentManagerException("Cannot get AtomicTypeConverter for element class " + elementClassName + " of class " + collectionDescriptor.getClassDescriptor().getClassName());
    }
}

