/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.collectionconverter.impl;

import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.exception.RepositoryException;
import org.apache.jackrabbit.ocm.manager.collectionconverter.CollectionConverter;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;

public abstract class AbstractCollectionConverterImpl
implements CollectionConverter {
    protected Map atomicTypeConverters;
    protected ObjectConverter objectConverter;
    protected Mapper mapper;

    public AbstractCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        this.atomicTypeConverters = atomicTypeConverters;
        this.objectConverter = objectConverter;
        this.mapper = mapper;
    }

    protected abstract void doInsertCollection(Session var1, Node var2, CollectionDescriptor var3, ManageableObjects var4) throws javax.jcr.RepositoryException;

    protected abstract void doUpdateCollection(Session var1, Node var2, CollectionDescriptor var3, ManageableObjects var4) throws javax.jcr.RepositoryException;

    protected abstract ManageableObjects doGetCollection(Session var1, Node var2, CollectionDescriptor var3, Class var4) throws javax.jcr.RepositoryException;

    protected abstract boolean doIsNull(Session var1, Node var2, CollectionDescriptor var3, Class var4) throws javax.jcr.RepositoryException;

    public void insertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) {
        try {
            this.doInsertCollection(session, parentNode, collectionDescriptor, objects);
        }
        catch (ItemExistsException iee) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName() + ". An item already exists.", iee);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), pnfe);
        }
        catch (VersionException ve) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), ve);
        }
        catch (ConstraintViolationException cve) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName() + ". Constraint violation.", cve);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName() + " on locked parent.", le);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), re);
        }
    }

    public void updateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) {
        try {
            this.doUpdateCollection(session, parentNode, collectionDescriptor, objects);
        }
        catch (VersionException ve) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), ve);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName() + " on locked node", le);
        }
        catch (ConstraintViolationException cve) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName() + " Constraint violation.", cve);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), re);
        }
    }

    public ManageableObjects getCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) {
        try {
            return this.doGetCollection(session, parentNode, collectionDescriptor, collectionFieldClass);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Cannot get collection field : " + collectionDescriptor.getFieldName() + "for " + collectionDescriptor.getClassDescriptor().getClassName(), re);
        }
    }

    public boolean isNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) {
        try {
            return this.doIsNull(session, parentNode, collectionDescriptor, collectionFieldClass);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Cannot  check if the collections has elements : " + collectionDescriptor.getFieldName() + "for " + collectionDescriptor.getClassDescriptor().getClassName(), re);
        }
    }

    protected String getCollectionJcrName(CollectionDescriptor descriptor) {
        String jcrName = descriptor.getJcrName();
        if (null == jcrName) {
            throw new JcrMappingException("The JcrName attribute is not defined for the CollectionDescriptor : " + descriptor.getFieldName());
        }
        return jcrName;
    }
}

