/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.beanconverter.impl;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.exception.RepositoryException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverterProvider;
import org.apache.jackrabbit.ocm.manager.beanconverter.BeanConverter;
import org.apache.jackrabbit.ocm.manager.beanconverter.impl.AbstractBeanConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.BeanDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentBeanConverterImpl
extends AbstractBeanConverterImpl
implements BeanConverter {
    private static final Logger log = LoggerFactory.getLogger(ParentBeanConverterImpl.class);

    public ParentBeanConverterImpl(Mapper mapper, ObjectConverter objectConverter, AtomicTypeConverterProvider atomicTypeConverterProvider) {
        super(mapper, objectConverter, atomicTypeConverterProvider);
    }

    public void insert(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
    }

    public void update(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
    }

    public Object getObject(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Class beanClass, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
        try {
            Node grandParentNode = parentNode.getParent();
            if (grandParentNode.getPath().equals("/")) {
                return null;
            }
            return this.objectConverter.getObject(session, grandParentNode.getPath());
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public void remove(Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Object object, ClassDescriptor parentClassDescriptor, Object parent) throws ObjectContentManagerException, RepositoryException, JcrMappingException {
    }

    public String getPath(Session session, BeanDescriptor beanDescriptor, Node parentNode) throws ObjectContentManagerException {
        try {
            if (parentNode != null) {
                return parentNode.getParent().getPath();
            }
            return null;
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }
}

