/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.ocm.exception.IncorrectAtomicTypeException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.BinaryTypeConverterImpl;

public class ByteArrayTypeConverterImpl
implements AtomicTypeConverter {
    public Value getValue(ValueFactory valueFactory, Object propValue) {
        if (propValue == null) {
            return null;
        }
        ByteArrayInputStream ins = new ByteArrayInputStream((byte[])propValue);
        return new BinaryTypeConverterImpl().getValue(valueFactory, ins);
    }

    public Object getObject(Value value) {
        try {
            return this.inputStreamToBytes(value.getBinary().getStream());
        }
        catch (Exception e) {
            throw new IncorrectAtomicTypeException("Impossible to convert a binary value.", e);
        }
    }

    public String getXPathQueryValue(ValueFactory valueFactory, Object object) {
        throw new IncorrectAtomicTypeException("Binary cannot be used in queries");
    }

    private byte[] inputStreamToBytes(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }
}

