/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl;

import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.ocm.exception.IncorrectAtomicTypeException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;

public class BinaryTypeConverterImpl
implements AtomicTypeConverter {
    public Value getValue(ValueFactory valueFactory, Object propValue) {
        if (propValue == null) {
            return null;
        }
        Binary binaryvalue = null;
        try {
            binaryvalue = valueFactory.createBinary((InputStream)propValue);
        }
        catch (RepositoryException ex) {
            throw new IncorrectAtomicTypeException("Impossible to create binary value from stream!", ex);
        }
        if (binaryvalue == null) {
            return null;
        }
        return valueFactory.createValue(binaryvalue);
    }

    public Object getObject(Value value) {
        try {
            return value.getBinary().getStream();
        }
        catch (RepositoryException e) {
            throw new IncorrectAtomicTypeException("Impossible to convert the value : " + value.toString(), e);
        }
    }

    public String getXPathQueryValue(ValueFactory valueFactory, Object object) {
        throw new IncorrectAtomicTypeException("Binary cannot be used in queries");
    }
}

