/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;

public class AlignedTimeSeriesMetadata
implements ITimeSeriesMetadata {
    private final TimeseriesMetadata timeseriesMetadata;
    private final List<TimeseriesMetadata> valueTimeseriesMetadataList;
    private IChunkMetadataLoader chunkMetadataLoader;

    public AlignedTimeSeriesMetadata(TimeseriesMetadata timeseriesMetadata, List<TimeseriesMetadata> valueTimeseriesMetadataList) {
        this.timeseriesMetadata = timeseriesMetadata;
        this.valueTimeseriesMetadataList = valueTimeseriesMetadataList;
    }

    @Override
    public Statistics getStatistics() {
        return this.valueTimeseriesMetadataList.size() == 1 && this.valueTimeseriesMetadataList.get(0) != null ? this.valueTimeseriesMetadataList.get(0).getStatistics() : this.timeseriesMetadata.getStatistics();
    }

    public Statistics getStatistics(int index) {
        TimeseriesMetadata v = this.valueTimeseriesMetadataList.get(index);
        return v == null ? null : v.getStatistics();
    }

    public Statistics getTimeStatistics() {
        return this.timeseriesMetadata.getStatistics();
    }

    @Override
    public boolean isModified() {
        return this.timeseriesMetadata.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        this.timeseriesMetadata.setModified(modified);
        for (TimeseriesMetadata subSensor : this.valueTimeseriesMetadataList) {
            if (subSensor == null) continue;
            subSensor.setModified(modified);
        }
    }

    @Override
    public boolean isSeq() {
        return this.timeseriesMetadata.isSeq();
    }

    @Override
    public void setSeq(boolean seq) {
        this.timeseriesMetadata.setSeq(seq);
        for (TimeseriesMetadata subSensor : this.valueTimeseriesMetadataList) {
            if (subSensor == null) continue;
            subSensor.setSeq(seq);
        }
    }

    @Override
    public List<IChunkMetadata> loadChunkMetadataList() throws IOException {
        return this.chunkMetadataLoader.loadChunkMetadataList(this);
    }

    public List<AlignedChunkMetadata> getChunkMetadataList() {
        List<IChunkMetadata> timeChunkMetadata = this.timeseriesMetadata.getChunkMetadataList();
        ArrayList<List<IChunkMetadata>> valueChunkMetadataList = new ArrayList<List<IChunkMetadata>>();
        for (TimeseriesMetadata metadata : this.valueTimeseriesMetadataList) {
            valueChunkMetadataList.add(metadata == null ? null : metadata.getChunkMetadataList());
        }
        ArrayList<AlignedChunkMetadata> res = new ArrayList<AlignedChunkMetadata>();
        for (int i = 0; i < timeChunkMetadata.size(); ++i) {
            ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>();
            boolean exits = false;
            for (List list : valueChunkMetadataList) {
                IChunkMetadata v = list == null || ((IChunkMetadata)list.get(i)).getStatistics().getCount() == 0L ? null : (IChunkMetadata)list.get(i);
                exits = exits || v != null;
                chunkMetadataList.add(v);
            }
            if (!exits) continue;
            res.add(new AlignedChunkMetadata(timeChunkMetadata.get(i), chunkMetadataList));
        }
        return res;
    }

    @Override
    public void setChunkMetadataLoader(IChunkMetadataLoader chunkMetadataLoader) {
        this.chunkMetadataLoader = chunkMetadataLoader;
    }

    public List<TimeseriesMetadata> getValueTimeseriesMetadataList() {
        return this.valueTimeseriesMetadataList;
    }

    public TimeseriesMetadata getTimeseriesMetadata() {
        return this.timeseriesMetadata;
    }
}

