/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.mybatis.plugin.generator;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.iotdb.mybatis.plugin.util.DateUtil;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.DefaultCommentGenerator;
import org.mybatis.generator.internal.util.StringUtility;

public class SwaggerCommentGenerator
extends DefaultCommentGenerator {
    private Properties properties;
    private boolean addRemarkComments = false;
    private static final String API_MODEL_FULL_CLASS_NAME = "io.swagger.v3.oas.annotations.media.Schema";

    public void addConfigurationProperties(Properties properties) {
        super.addConfigurationProperties(properties);
        this.addRemarkComments = StringUtility.isTrue((String)properties.getProperty("addRemarkComments"));
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        String remarks = introspectedColumn.getRemarks();
        if (this.addRemarkComments && StringUtility.stringHasValue((String)remarks)) {
            this.addFieldJavaDoc(field, introspectedColumn);
            if (remarks.contains("\"")) {
                remarks = remarks.replace("\"", "'");
            }
            field.addJavaDocLine("@Schema(title = \"" + remarks + "\")");
        }
    }

    private void addFieldJavaDoc(Field field, IntrospectedColumn introspectedColumn) {
        StringBuffer sb = new StringBuffer();
        sb.append("/**\n    ");
        sb.append(" * field: ");
        sb.append(introspectedColumn.getActualColumnName());
        String remarks = introspectedColumn.getRemarks();
        if (StringUtility.stringHasValue((String)remarks)) {
            sb.append("\uff0c");
            sb.append(remarks);
        }
        sb.append("\n     */");
        field.addJavaDocLine(sb.toString());
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        StringBuilder sb = new StringBuilder();
        topLevelClass.addJavaDocLine("/**");
        topLevelClass.addJavaDocLine(" *");
        String remarks = introspectedTable.getRemarks();
        if (StringUtility.stringHasValue((String)remarks)) {
            String[] remarkLines;
            for (String remarkLine : remarkLines = remarks.split(System.getProperty("line.separator"))) {
                topLevelClass.addJavaDocLine(" * " + remarkLine);
            }
            sb.append(" * ");
        }
        sb.append("table: ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append(" of model class");
        topLevelClass.addJavaDocLine(sb.toString());
        topLevelClass.addJavaDocLine(" *");
        String author = "IoTDB";
        if (this.properties.containsKey("author")) {
            author = this.properties.getProperty("author");
        }
        topLevelClass.addJavaDocLine(" * @author " + author);
        topLevelClass.addJavaDocLine(" * @date " + DateUtil.date2Str(new Date()));
        topLevelClass.addJavaDocLine(" */");
        FullyQualifiedJavaType serializable = new FullyQualifiedJavaType("java.io.Serializable");
        topLevelClass.addImportedType(serializable);
        topLevelClass.addSuperInterface(serializable);
        FullyQualifiedJavaType fullyQualifiedJavaType = new FullyQualifiedJavaType("long");
        Field serialVersionUID = new Field("serialVersionUID", fullyQualifiedJavaType);
        serialVersionUID.setVisibility(JavaVisibility.PRIVATE);
        serialVersionUID.setStatic(true);
        serialVersionUID.setFinal(true);
        serialVersionUID.setName("serialVersionUID");
        serialVersionUID.setType(fullyQualifiedJavaType);
        serialVersionUID.setInitializationString("1L");
        sb = new StringBuilder();
        sb.append("/**\n    ");
        sb.append(" * class serial version id\n    ");
        sb.append(" */");
        serialVersionUID.addJavaDocLine(sb.toString());
        topLevelClass.addField(serialVersionUID);
        topLevelClass.addImportedType(API_MODEL_FULL_CLASS_NAME);
        topLevelClass.addAnnotation("@Schema(title = \"" + introspectedTable.getFullyQualifiedTable() + "\", description = \"" + remarks + "\")");
    }

    public void addJavaFileComment(CompilationUnit compilationUnit) {
        compilationUnit.addFileCommentLine("/**");
        String copyright = " * Copyright From 2025, IoTDB.";
        compilationUnit.addFileCommentLine(copyright);
        compilationUnit.addFileCommentLine(" * ");
        compilationUnit.addFileCommentLine(" * " + compilationUnit.getType().getShortNameWithoutTypeArguments() + ".java");
        compilationUnit.addFileCommentLine(" */");
    }
}

