/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.mybatis.plugin.generator;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.iotdb.mybatis.plugin.util.DateUtil;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.DefaultCommentGenerator;
import org.mybatis.generator.internal.util.StringUtility;

public class CNCommentGenerator
extends DefaultCommentGenerator {
    private Properties properties;

    public void addConfigurationProperties(Properties properties) {
        super.addConfigurationProperties(properties);
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void addJavaFileComment(CompilationUnit compilationUnit) {
        compilationUnit.addFileCommentLine("/**");
        String copyright = " * Copyright From 2025. IoTDB.";
        compilationUnit.addFileCommentLine(copyright);
        compilationUnit.addFileCommentLine(" * ");
        compilationUnit.addFileCommentLine(" * " + compilationUnit.getType().getShortNameWithoutTypeArguments() + ".java");
        compilationUnit.addFileCommentLine(" */");
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        StringBuilder sb = new StringBuilder();
        topLevelClass.addJavaDocLine("/**");
        topLevelClass.addJavaDocLine(" *");
        String remarks = introspectedTable.getRemarks();
        if (StringUtility.stringHasValue((String)remarks)) {
            String[] remarkLines;
            for (String remarkLine : remarkLines = remarks.split(System.getProperty("line.separator"))) {
                topLevelClass.addJavaDocLine(" * " + remarkLine);
            }
            sb.append(" * ");
        }
        sb.append("table: ");
        sb.append(introspectedTable.getFullyQualifiedTable());
        sb.append(" of model class");
        topLevelClass.addJavaDocLine(sb.toString());
        topLevelClass.addJavaDocLine(" *");
        String author = "IoTDB";
        if (this.properties.containsKey("author")) {
            author = this.properties.getProperty("author");
        }
        topLevelClass.addJavaDocLine(" * @author " + author);
        topLevelClass.addJavaDocLine(" * @date " + DateUtil.date2Str(new Date()));
        topLevelClass.addJavaDocLine(" */");
        FullyQualifiedJavaType serializable = new FullyQualifiedJavaType("java.io.Serializable");
        topLevelClass.addImportedType(serializable);
        topLevelClass.addSuperInterface(serializable);
        FullyQualifiedJavaType qualifiedJavaType = new FullyQualifiedJavaType("long");
        Field serialVersionUID = new Field("serialVersionUID", qualifiedJavaType);
        serialVersionUID.setVisibility(JavaVisibility.PRIVATE);
        serialVersionUID.setStatic(true);
        serialVersionUID.setFinal(true);
        serialVersionUID.setName("serialVersionUID");
        serialVersionUID.setType(qualifiedJavaType);
        serialVersionUID.setInitializationString("1L");
        sb = new StringBuilder();
        sb.append("/**\n    ");
        sb.append(" * class serial version id\n    ");
        sb.append(" */");
        serialVersionUID.addJavaDocLine(sb.toString());
        topLevelClass.addField(serialVersionUID);
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        StringBuffer sb = new StringBuffer();
        sb.append("/**\n    ");
        sb.append(" * field: ");
        sb.append(introspectedColumn.getActualColumnName());
        String remarks = introspectedColumn.getRemarks();
        if (StringUtility.stringHasValue((String)remarks)) {
            sb.append("\uff0c");
            sb.append(remarks);
        }
        sb.append("\n     */");
        field.addJavaDocLine(sb.toString());
    }
}

