/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.mybatis.plugin;

import java.util.List;
import java.util.TreeSet;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class BatchInsertPlugin
extends PluginAdapter {
    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        this.batchInsertMethod(interfaze, introspectedTable);
        return super.clientGenerated(interfaze, introspectedTable);
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        this.addBatchInsertXml(document, introspectedTable);
        return super.sqlMapDocumentGenerated(document, introspectedTable);
    }

    public boolean validate(List<String> list) {
        return true;
    }

    private void batchInsertMethod(Interface interfaze, IntrospectedTable introspectedTable) {
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        importedTypes.add(FullyQualifiedJavaType.getNewListInstance());
        importedTypes.add(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        Method ibsmethod = new Method("batchInsert");
        ibsmethod.setVisibility(JavaVisibility.PUBLIC);
        ibsmethod.setAbstract(true);
        FullyQualifiedJavaType ibsReturnType = FullyQualifiedJavaType.getIntInstance();
        ibsmethod.setReturnType(ibsReturnType);
        ibsmethod.setName("batchInsert");
        FullyQualifiedJavaType paramType = FullyQualifiedJavaType.getNewListInstance();
        FullyQualifiedJavaType paramListType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        paramType.addTypeArgument(paramListType);
        ibsmethod.addParameter(new Parameter(paramType, "records", "@Param(\"records\")"));
        interfaze.addImportedTypes(importedTypes);
        interfaze.addMethod(ibsmethod);
    }

    private void addBatchInsertXml(Document document, IntrospectedTable introspectedTable) {
        List columns = introspectedTable.getAllColumns();
        String incrementField = introspectedTable.getTableConfiguration().getProperties().getProperty("incrementField");
        if (incrementField != null) {
            incrementField = incrementField.toUpperCase();
        }
        XmlElement insertBatchElement = new XmlElement("insert");
        insertBatchElement.addAttribute(new Attribute("id", "batchInsert"));
        insertBatchElement.addAttribute(new Attribute("parameterType", "java.util.List"));
        StringBuilder sqlElement = new StringBuilder();
        StringBuilder javaPropertyAndDbType = new StringBuilder("(");
        for (IntrospectedColumn introspectedColumn : columns) {
            String columnName = introspectedColumn.getActualColumnName();
            if (columnName.toUpperCase().equals(incrementField)) continue;
            sqlElement.append(columnName + ",\n      ");
            javaPropertyAndDbType.append("\n      #{item." + introspectedColumn.getJavaProperty() + ",jdbcType=" + introspectedColumn.getJdbcTypeName() + "},");
        }
        XmlElement foreachElement = new XmlElement("foreach");
        foreachElement.addAttribute(new Attribute("collection", "records"));
        foreachElement.addAttribute(new Attribute("index", "index"));
        foreachElement.addAttribute(new Attribute("item", "item"));
        foreachElement.addAttribute(new Attribute("separator", ","));
        insertBatchElement.addElement((VisitableElement)new TextElement("insert into " + introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime() + " ("));
        insertBatchElement.addElement((VisitableElement)new TextElement("  " + sqlElement.delete(sqlElement.lastIndexOf(","), sqlElement.length()).toString()));
        insertBatchElement.addElement((VisitableElement)new TextElement(") values "));
        foreachElement.addElement((VisitableElement)new TextElement(javaPropertyAndDbType.delete(javaPropertyAndDbType.length() - 1, javaPropertyAndDbType.length()).append("\n      )").toString()));
        insertBatchElement.addElement((VisitableElement)foreachElement);
        document.getRootElement().addElement((VisitableElement)insertBatchElement);
    }
}

