/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import java.util.Objects;
import org.apache.iotdb.rpc.subscription.payload.EnrichedTablets;
import org.apache.iotdb.session.subscription.SubscriptionMessagePayload;
import org.apache.iotdb.session.subscription.SubscriptionSessionDataSets;

public class SubscriptionMessage
implements Comparable<SubscriptionMessage> {
    private final SubscriptionMessagePayload payload;
    private final String topicName;
    private final String subscriptionCommitId;

    public SubscriptionMessage(EnrichedTablets tablets) {
        this.payload = new SubscriptionSessionDataSets(tablets.getTablets());
        this.topicName = tablets.getTopicName();
        this.subscriptionCommitId = tablets.getSubscriptionCommitId();
    }

    public String getTopicName() {
        return this.topicName;
    }

    public SubscriptionMessagePayload getPayload() {
        return this.payload;
    }

    String getSubscriptionCommitId() {
        return this.subscriptionCommitId;
    }

    int parseDataNodeIdFromSubscriptionCommitId() {
        return Integer.parseInt(this.subscriptionCommitId.split("#")[0]);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionMessage that = (SubscriptionMessage)obj;
        return Objects.equals(this.topicName, that.topicName) && Objects.equals(this.subscriptionCommitId, that.subscriptionCommitId);
    }

    public int hashCode() {
        return Objects.hash(this.topicName, this.subscriptionCommitId);
    }

    @Override
    public int compareTo(SubscriptionMessage that) {
        if (this.topicName.compareTo(that.topicName) == 0) {
            return this.subscriptionCommitId.compareTo(that.subscriptionCommitId);
        }
        return this.topicName.compareTo(that.topicName);
    }
}

