/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service.thrift;

import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCServiceHandler;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCServiceMBean;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCServiceMetrics;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCServiceProcessor;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.thrift.server.TServerEventHandler;

public class ConfigNodeRPCService
extends ThriftService
implements ConfigNodeRPCServiceMBean {
    private static final ConfigNodeConfig configConf = ConfigNodeDescriptor.getInstance().getConf();
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private ConfigNodeRPCServiceProcessor configNodeRPCServiceProcessor;

    public ServiceType getID() {
        return ServiceType.CONFIG_NODE_SERVICE;
    }

    public void initSyncedServiceImpl(Object configNodeRPCServerProcessor) {
        this.configNodeRPCServiceProcessor = (ConfigNodeRPCServiceProcessor)configNodeRPCServerProcessor;
        this.mbeanName = String.format("%s:%s=%s", this.getClass().getPackage(), "type", this.getID().getJmxName());
        super.initSyncedServiceImpl((Object)this.configNodeRPCServiceProcessor);
    }

    public void initTProcessor() throws InstantiationException {
        this.processor = new IConfigNodeRPCService.Processor((IConfigNodeRPCService.Iface)this.configNodeRPCServiceProcessor);
    }

    public void initThriftServiceThread() throws IllegalAccessException {
        try {
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.CONFIGNODE_RPC_PROCESSOR.getName(), this.getBindIP(), this.getBindPort(), configConf.getRpcMaxConcurrentClientNum(), configConf.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new ConfigNodeRPCServiceHandler(), commonConfig.isRpcThriftCompressionEnabled());
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.CONFIGNODE_RPC_SERVICE.getName());
        MetricService.getInstance().addMetricSet((IMetricSet)new ConfigNodeRPCServiceMetrics(this.thriftServiceThread));
    }

    public String getBindIP() {
        return configConf.getInternalAddress();
    }

    public int getBindPort() {
        return configConf.getInternalPort();
    }
}

