/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.impl.CreateTriggerProcedure;
import org.apache.iotdb.confignode.procedure.impl.DropTriggerProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AddConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveDataNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.CreateRegionGroupsProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.DeleteStorageGroupProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.DeleteTimeSeriesProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.statemachine.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.CreatePipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.DropPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.StartPipeProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.StopPipeProcedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureFactory
implements IProcedureFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureFactory.class);

    @Override
    public Procedure create(ByteBuffer buffer) throws IOException {
        StateMachineProcedure procedure;
        int typeNum = buffer.getInt();
        if (typeNum >= ProcedureType.values().length) {
            LOGGER.error("unrecognized log type " + typeNum);
            throw new IOException("unrecognized log type " + typeNum);
        }
        ProcedureType type = ProcedureType.values()[typeNum];
        switch (type) {
            case DELETE_STORAGE_GROUP_PROCEDURE: {
                procedure = new DeleteStorageGroupProcedure();
                break;
            }
            case ADD_CONFIG_NODE_PROCEDURE: {
                procedure = new AddConfigNodeProcedure();
                break;
            }
            case REMOVE_CONFIG_NODE_PROCEDURE: {
                procedure = new RemoveConfigNodeProcedure();
                break;
            }
            case REMOVE_DATA_NODE_PROCEDURE: {
                procedure = new RemoveDataNodeProcedure();
                break;
            }
            case REGION_MIGRATE_PROCEDURE: {
                procedure = new RegionMigrateProcedure();
                break;
            }
            case CREATE_REGION_GROUPS: {
                procedure = new CreateRegionGroupsProcedure();
                break;
            }
            case DELETE_TIMESERIES_PROCEDURE: {
                procedure = new DeleteTimeSeriesProcedure();
                break;
            }
            case CREATE_TRIGGER_PROCEDURE: {
                procedure = new CreateTriggerProcedure();
                break;
            }
            case DROP_TRIGGER_PROCEDURE: {
                procedure = new DropTriggerProcedure();
                break;
            }
            case CREATE_PIPE_PROCEDURE: {
                procedure = new CreatePipeProcedure();
                break;
            }
            case START_PIPE_PROCEDURE: {
                procedure = new StartPipeProcedure();
                break;
            }
            case STOP_PIPE_PROCEDURE: {
                procedure = new StopPipeProcedure();
                break;
            }
            case DROP_PIPE_PROCEDURE: {
                procedure = new DropPipeProcedure();
                break;
            }
            default: {
                LOGGER.error("unknown Procedure type: " + typeNum);
                throw new IOException("unknown Procedure type: " + typeNum);
            }
        }
        ((Procedure)procedure).deserialize(buffer);
        return procedure;
    }

    public static ProcedureType getProcedureType(Procedure procedure) {
        if (procedure instanceof DeleteStorageGroupProcedure) {
            return ProcedureType.DELETE_STORAGE_GROUP_PROCEDURE;
        }
        if (procedure instanceof AddConfigNodeProcedure) {
            return ProcedureType.ADD_CONFIG_NODE_PROCEDURE;
        }
        if (procedure instanceof RemoveConfigNodeProcedure) {
            return ProcedureType.REMOVE_CONFIG_NODE_PROCEDURE;
        }
        if (procedure instanceof RemoveDataNodeProcedure) {
            return ProcedureType.REMOVE_DATA_NODE_PROCEDURE;
        }
        if (procedure instanceof RegionMigrateProcedure) {
            return ProcedureType.REGION_MIGRATE_PROCEDURE;
        }
        if (procedure instanceof CreateRegionGroupsProcedure) {
            return ProcedureType.CREATE_REGION_GROUPS;
        }
        if (procedure instanceof DeleteTimeSeriesProcedure) {
            return ProcedureType.DELETE_TIMESERIES_PROCEDURE;
        }
        if (procedure instanceof CreateTriggerProcedure) {
            return ProcedureType.CREATE_TRIGGER_PROCEDURE;
        }
        if (procedure instanceof DropTriggerProcedure) {
            return ProcedureType.DROP_TRIGGER_PROCEDURE;
        }
        if (procedure instanceof CreatePipeProcedure) {
            return ProcedureType.CREATE_PIPE_PROCEDURE;
        }
        if (procedure instanceof StartPipeProcedure) {
            return ProcedureType.START_PIPE_PROCEDURE;
        }
        if (procedure instanceof StopPipeProcedure) {
            return ProcedureType.STOP_PIPE_PROCEDURE;
        }
        if (procedure instanceof DropPipeProcedure) {
            return ProcedureType.DROP_PIPE_PROCEDURE;
        }
        return null;
    }

    public static ProcedureFactory getInstance() {
        return ProcedureFactoryHolder.INSTANCE;
    }

    private static class ProcedureFactoryHolder {
        private static final ProcedureFactory INSTANCE = new ProcedureFactory();

        private ProcedureFactoryHolder() {
        }
    }

    public static enum ProcedureType {
        DELETE_STORAGE_GROUP_PROCEDURE,
        ADD_CONFIG_NODE_PROCEDURE,
        REMOVE_CONFIG_NODE_PROCEDURE,
        REMOVE_DATA_NODE_PROCEDURE,
        REGION_MIGRATE_PROCEDURE,
        CREATE_REGION_GROUPS,
        DELETE_TIMESERIES_PROCEDURE,
        CREATE_TRIGGER_PROCEDURE,
        DROP_TRIGGER_PROCEDURE,
        CREATE_PIPE_PROCEDURE,
        START_PIPE_PROCEDURE,
        STOP_PIPE_PROCEDURE,
        DROP_PIPE_PROCEDURE;

    }
}

