/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.metric;

import java.util.Objects;
import org.apache.iotdb.confignode.persistence.NodeInfo;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class NodeInfoMetrics
implements IMetricSet {
    private final NodeInfo nodeInfo;

    public NodeInfoMetrics(NodeInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.getOrCreateAutoGauge(Metric.CONFIG_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.nodeInfo.getRegisteredConfigNodeCount(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
        metricService.getOrCreateAutoGauge(Metric.DATA_NODE.toString(), MetricLevel.CORE, (Object)this, o -> this.nodeInfo.getRegisteredDataNodeCount(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, Metric.CONFIG_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
        metricService.remove(MetricType.GAUGE, Metric.DATA_NODE.toString(), new String[]{Tag.NAME.toString(), "total", Tag.STATUS.toString(), "Registered"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfoMetrics that = (NodeInfoMetrics)o;
        return Objects.equals(this.nodeInfo, that.nodeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.nodeInfo);
    }
}

