/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.cluster.RegionRoleType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetRoutingPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetSeriesSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetTimeSlotListPlan;
import org.apache.iotdb.confignode.consensus.request.write.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.PollRegionMaintainTaskPlan;
import org.apache.iotdb.confignode.consensus.request.write.storagegroup.PreDeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.response.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.GetRoutingResp;
import org.apache.iotdb.confignode.consensus.response.GetSeriesSlotListResp;
import org.apache.iotdb.confignode.consensus.response.GetTimeSlotListResp;
import org.apache.iotdb.confignode.consensus.response.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.SchemaPartitionResp;
import org.apache.iotdb.confignode.exception.NotAvailableRegionGroupException;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.partition.RegionGroupCache;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.apache.iotdb.confignode.manager.partition.RegionHeartbeatSample;
import org.apache.iotdb.confignode.persistence.metric.PartitionInfoMetrics;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.partition.RegionCreateTask;
import org.apache.iotdb.confignode.persistence.partition.RegionDeleteTask;
import org.apache.iotdb.confignode.persistence.partition.RegionMaintainTask;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionManager.class);
    private final IManager configManager;
    private final PartitionInfo partitionInfo;
    private SeriesPartitionExecutor executor;
    private final Object scheduleMonitor = new Object();
    private static final int REGION_MAINTAINER_WORK_INTERVAL = 10;
    private final ScheduledExecutorService regionMaintainer;
    private Future<?> currentRegionMaintainerFuture;
    private final Map<TConsensusGroupId, RegionGroupCache> regionGroupCacheMap;

    public PartitionManager(IManager configManager, PartitionInfo partitionInfo) {
        this.configManager = configManager;
        this.partitionInfo = partitionInfo;
        this.regionMaintainer = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"IoTDB-Region-Maintainer");
        this.regionGroupCacheMap = new ConcurrentHashMap<TConsensusGroupId, RegionGroupCache>();
        this.setSeriesPartitionExecutor();
    }

    private void setSeriesPartitionExecutor() {
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        this.executor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)conf.getSeriesPartitionExecutorClass(), (int)conf.getSeriesPartitionSlotNum());
    }

    public DataSet getSchemaPartition(GetSchemaPartitionPlan req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    public DataSet getDataPartition(GetDataPartitionPlan req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaPartitionResp getOrCreateSchemaPartition(GetOrCreateSchemaPartitionPlan req) {
        SchemaPartitionResp resp = (SchemaPartitionResp)this.getSchemaPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, SchemaPartitionTable> assignedSchemaPartition;
            Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap = this.partitionInfo.filterUnassignedSchemaPartitionSlots(req.getPartitionSlotsMap());
            ConcurrentHashMap<String, Integer> unassignedSchemaPartitionSlotsCountMap = new ConcurrentHashMap<String, Integer>();
            unassignedSchemaPartitionSlotsMap.forEach((storageGroup, unassignedSchemaPartitionSlots) -> unassignedSchemaPartitionSlotsCountMap.put((String)storageGroup, unassignedSchemaPartitionSlots.size()));
            TSStatus status = this.extendRegionsIfNecessary(unassignedSchemaPartitionSlotsCountMap, TConsensusGroupType.SchemaRegion);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            status = this.getConsensusManager().confirmLeader();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            try {
                assignedSchemaPartition = this.getLoadManager().allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
            }
            catch (NotAvailableRegionGroupException e) {
                LOGGER.error(e.getMessage());
                resp.setStatus(new TSStatus(TSStatusCode.NOT_AVAILABLE_REGION_GROUP.getStatusCode()).setMessage(e.getMessage()));
                return resp;
            }
            CreateSchemaPartitionPlan createPlan = new CreateSchemaPartitionPlan();
            createPlan.setAssignedSchemaPartition(assignedSchemaPartition);
            this.getConsensusManager().write(createPlan);
        }
        return (SchemaPartitionResp)this.getSchemaPartition(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPartitionResp getOrCreateDataPartition(GetOrCreateDataPartitionPlan req) {
        DataPartitionResp resp = (DataPartitionResp)this.getDataPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, DataPartitionTable> assignedDataPartition;
            Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> unassignedDataPartitionSlotsMap = this.partitionInfo.filterUnassignedDataPartitionSlots(req.getPartitionSlotsMap());
            ConcurrentHashMap<String, Integer> unassignedDataPartitionSlotsCountMap = new ConcurrentHashMap<String, Integer>();
            unassignedDataPartitionSlotsMap.forEach((storageGroup, unassignedDataPartitionSlots) -> unassignedDataPartitionSlotsCountMap.put((String)storageGroup, unassignedDataPartitionSlots.size()));
            TSStatus status = this.extendRegionsIfNecessary(unassignedDataPartitionSlotsCountMap, TConsensusGroupType.DataRegion);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            status = this.getConsensusManager().confirmLeader();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            try {
                assignedDataPartition = this.getLoadManager().allocateDataPartition(unassignedDataPartitionSlotsMap);
            }
            catch (NotAvailableRegionGroupException e) {
                LOGGER.error(e.getMessage());
                resp.setStatus(new TSStatus(TSStatusCode.NOT_AVAILABLE_REGION_GROUP.getStatusCode()).setMessage(e.getMessage()));
                return resp;
            }
            CreateDataPartitionPlan createPlan = new CreateDataPartitionPlan();
            createPlan.setAssignedDataPartition(assignedDataPartition);
            this.getConsensusManager().write(createPlan);
        }
        return (DataPartitionResp)this.getDataPartition(req);
    }

    private TSStatus extendRegionsIfNecessary(Map<String, Integer> unassignedPartitionSlotsCountMap, TConsensusGroupType consensusGroupType) {
        TSStatus result = new TSStatus();
        try {
            ConcurrentHashMap<String, Integer> allotmentMap = new ConcurrentHashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry : unassignedPartitionSlotsCountMap.entrySet()) {
                int delta;
                String storageGroup = entry.getKey();
                int unassignedPartitionSlotsCount = entry.getValue();
                float allocatedRegionCount = this.partitionInfo.getRegionCount(storageGroup, consensusGroupType);
                float slotCount = (float)this.partitionInfo.getAssignedSeriesPartitionSlotsCount(storageGroup) + (float)unassignedPartitionSlotsCount;
                float maxRegionCount = this.getClusterSchemaManager().getMaxRegionGroupCount(storageGroup, consensusGroupType);
                float maxSlotCount = ConfigNodeDescriptor.getInstance().getConf().getSeriesPartitionSlotNum();
                if (allocatedRegionCount == 0.0f) {
                    delta = Math.min((int)maxRegionCount, Math.max(1, (int)Math.ceil(slotCount * maxRegionCount / maxSlotCount)));
                    allotmentMap.put(storageGroup, delta);
                    continue;
                }
                if (allocatedRegionCount < maxRegionCount && slotCount / allocatedRegionCount > maxSlotCount / maxRegionCount) {
                    delta = Math.min((int)(maxRegionCount - allocatedRegionCount), Math.max(1, (int)Math.ceil(slotCount * maxRegionCount / maxSlotCount - allocatedRegionCount)));
                    allotmentMap.put(storageGroup, delta);
                    continue;
                }
                if (allocatedRegionCount != (float)this.filterRegionGroupThroughStatus(storageGroup, RegionGroupStatus.Disabled).size() || !(allocatedRegionCount < maxRegionCount)) continue;
                allotmentMap.put(storageGroup, 1);
            }
            if (!allotmentMap.isEmpty()) {
                CreateRegionGroupsPlan createRegionGroupsPlan = this.getLoadManager().allocateRegionGroups(allotmentMap, consensusGroupType);
                result = this.getProcedureManager().createRegionGroups(consensusGroupType, createRegionGroupsPlan);
            } else {
                result = RpcUtils.SUCCESS_STATUS;
            }
        }
        catch (NotEnoughDataNodeException e) {
            String prompt = "ConfigNode failed to extend Region because there are not enough DataNodes";
            LOGGER.error(prompt);
            result.setCode(TSStatusCode.NOT_ENOUGH_DATA_NODE.getStatusCode());
            result.setMessage(prompt);
        }
        catch (StorageGroupNotExistsException e) {
            String prompt = "ConfigNode failed to extend Region because some StorageGroup doesn't exist.";
            LOGGER.error(prompt);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
            result.setMessage(prompt);
        }
        return result;
    }

    public TConsensusGroupId getPrecededDataPartition(String storageGroup, TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot, long timePartitionInterval) {
        return this.partitionInfo.getPrecededDataPartition(storageGroup, seriesPartitionSlot, timePartitionSlot, timePartitionInterval);
    }

    public Set<TDataNodeLocation> getStorageGroupRelatedDataNodes(String storageGroup, TConsensusGroupType type) {
        return this.partitionInfo.getStorageGroupRelatedDataNodes(storageGroup, type);
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        return this.partitionInfo.getAllReplicaSets();
    }

    public List<TRegionReplicaSet> getAllReplicaSets(String storageGroup) {
        return this.partitionInfo.getAllReplicaSets(storageGroup);
    }

    public int getRegionCount(String storageGroup, TConsensusGroupType type) throws StorageGroupNotExistsException {
        return this.partitionInfo.getRegionCount(storageGroup, type);
    }

    public List<Pair<Long, TConsensusGroupId>> getSortedRegionGroupSlotsCounter(String storageGroup, TConsensusGroupType type) throws NotAvailableRegionGroupException {
        List<Pair<Long, TConsensusGroupId>> regionGroupSlotsCounter = this.partitionInfo.getRegionGroupSlotsCounter(storageGroup, type);
        ArrayList<Pair<Long, TConsensusGroupId>> result = new ArrayList<Pair<Long, TConsensusGroupId>>();
        for (Pair<Long, TConsensusGroupId> slotsCounter : regionGroupSlotsCounter) {
            RegionGroupStatus status = this.getRegionGroupStatus((TConsensusGroupId)slotsCounter.getRight());
            if (!RegionGroupStatus.Running.equals((Object)status) && !RegionGroupStatus.Available.equals((Object)status)) continue;
            result.add(slotsCounter);
        }
        if (result.isEmpty()) {
            throw new NotAvailableRegionGroupException();
        }
        result.sort(Comparator.comparingLong(Pair::getLeft));
        return result;
    }

    public int generateNextRegionGroupId() {
        return this.partitionInfo.generateNextRegionGroupId();
    }

    public SchemaNodeManagementResp getNodePathsPartition(GetNodePathsPartitionPlan physicalPlan) {
        ConsensusReadResponse consensusReadResponse = this.getConsensusManager().read(physicalPlan);
        SchemaNodeManagementResp schemaNodeManagementResp = (SchemaNodeManagementResp)consensusReadResponse.getDataset();
        return schemaNodeManagementResp;
    }

    public void preDeleteStorageGroup(String storageGroup, PreDeleteStorageGroupPlan.PreDeleteType preDeleteType) {
        PreDeleteStorageGroupPlan preDeleteStorageGroupPlan = new PreDeleteStorageGroupPlan(storageGroup, preDeleteType);
        this.getConsensusManager().write(preDeleteStorageGroupPlan);
    }

    public void addMetrics() {
        MetricService.getInstance().addMetricSet((IMetricSet)new PartitionInfoMetrics(this.partitionInfo));
    }

    public TSeriesPartitionSlot getSeriesPartitionSlot(String devicePath) {
        return this.executor.getSeriesPartitionSlot(devicePath);
    }

    public RegionInfoListResp getRegionInfoList(GetRegionInfoListPlan req) {
        RegionInfoListResp regionInfoListResp = (RegionInfoListResp)this.getConsensusManager().read(req).getDataset();
        Map<TConsensusGroupId, Integer> allLeadership = this.getAllLeadership();
        regionInfoListResp.getRegionInfoList().forEach(regionInfo -> {
            regionInfo.setStatus(this.getRegionStatus(regionInfo.getConsensusGroupId(), regionInfo.getDataNodeId()).getStatus());
            String regionType = regionInfo.getDataNodeId() == allLeadership.getOrDefault(regionInfo.getConsensusGroupId(), -1).intValue() ? RegionRoleType.Leader.toString() : RegionRoleType.Follower.toString();
            regionInfo.setRoleType(regionType);
        });
        return regionInfoListResp;
    }

    public TSStatus updateRegionLocation(UpdateRegionLocationPlan req) {
        if (this.regionGroupCacheMap.containsKey(req.getRegionId())) {
            this.regionGroupCacheMap.get(req.getRegionId()).removeCacheIfExists(req.getOldNode().getDataNodeId());
        }
        return this.getConsensusManager().write(req).getStatus();
    }

    public GetRoutingResp getRouting(GetRoutingPlan plan) {
        return (GetRoutingResp)this.getConsensusManager().read(plan).getDataset();
    }

    public GetTimeSlotListResp getTimeSlotList(GetTimeSlotListPlan plan) {
        return (GetTimeSlotListResp)this.getConsensusManager().read(plan).getDataset();
    }

    public GetSeriesSlotListResp getSeriesSlotList(GetSeriesSlotListPlan plan) {
        return (GetSeriesSlotListResp)this.getConsensusManager().read(plan).getDataset();
    }

    public String getRegionStorageGroup(TConsensusGroupId regionId) {
        return this.partitionInfo.getRegionStorageGroup(regionId);
    }

    public void maintainRegionReplicas() {
        Optional.ofNullable(this.getConsensusManager()).ifPresent(consensusManager -> {
            List<RegionMaintainTask> regionMaintainTaskList;
            if (this.getConsensusManager().isLeader() && !(regionMaintainTaskList = this.partitionInfo.getRegionMaintainEntryList()).isEmpty()) {
                for (RegionMaintainTask entry : regionMaintainTaskList) {
                    TSStatus status;
                    block0 : switch (entry.getType()) {
                        case CREATE: {
                            RegionCreateTask createEntry = (RegionCreateTask)entry;
                            LOGGER.info("Start to create Region: {} on DataNode: {}", (Object)createEntry.getRegionReplicaSet().getRegionId(), (Object)createEntry.getTargetDataNode());
                            switch (createEntry.getRegionReplicaSet().getRegionId().getType()) {
                                case SchemaRegion: {
                                    status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(createEntry.getTargetDataNode().getInternalEndPoint(), new TCreateSchemaRegionReq(createEntry.getRegionReplicaSet(), createEntry.getStorageGroup()), DataNodeRequestType.CREATE_SCHEMA_REGION);
                                    break block0;
                                }
                            }
                            status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(createEntry.getTargetDataNode().getInternalEndPoint(), new TCreateDataRegionReq(createEntry.getRegionReplicaSet(), createEntry.getStorageGroup()).setTtl(createEntry.getTTL()), DataNodeRequestType.CREATE_DATA_REGION);
                            break;
                        }
                        default: {
                            RegionDeleteTask deleteEntry = (RegionDeleteTask)entry;
                            LOGGER.info("Start to delete Region: {} on DataNode: {}", (Object)deleteEntry.getRegionId(), (Object)deleteEntry.getTargetDataNode());
                            status = SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(deleteEntry.getTargetDataNode().getInternalEndPoint(), deleteEntry.getRegionId(), DataNodeRequestType.DELETE_REGION);
                        }
                    }
                    if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) break;
                    this.getConsensusManager().write(new PollRegionMaintainTaskPlan());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRegionCleaner() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentRegionMaintainerFuture == null) {
                this.currentRegionMaintainerFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.regionMaintainer, this::maintainRegionReplicas, (long)0L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
                LOGGER.info("RegionCleaner is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRegionCleaner() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentRegionMaintainerFuture != null) {
                this.currentRegionMaintainerFuture.cancel(false);
                this.currentRegionMaintainerFuture = null;
                this.regionGroupCacheMap.clear();
                LOGGER.info("RegionCleaner is stopped successfully.");
            }
        }
    }

    public Map<TConsensusGroupId, RegionGroupCache> getRegionGroupCacheMap() {
        return this.regionGroupCacheMap;
    }

    public void removeRegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.regionGroupCacheMap.remove(consensusGroupId);
    }

    public Map<TConsensusGroupId, Integer> getAllLeadership() {
        ConcurrentHashMap<TConsensusGroupId, Integer> result = new ConcurrentHashMap<TConsensusGroupId, Integer>();
        if (ConfigNodeDescriptor.getInstance().getConf().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.multileader.MultiLeaderConsensus")) {
            this.regionGroupCacheMap.forEach((consensusGroupId, regionGroupCache) -> {
                if (consensusGroupId.getType().equals((Object)TConsensusGroupType.SchemaRegion)) {
                    int leaderDataNodeId = regionGroupCache.getLeaderDataNodeId();
                    if (this.configManager.getNodeManager().isNodeRemoving(leaderDataNodeId)) {
                        result.put((TConsensusGroupId)consensusGroupId, -1);
                    } else {
                        result.put((TConsensusGroupId)consensusGroupId, leaderDataNodeId);
                    }
                }
            });
            this.getLoadManager().getRouteBalancer().getRouteMap().forEach((consensusGroupId, regionReplicaSet) -> result.put((TConsensusGroupId)consensusGroupId, ((TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0)).getDataNodeId()));
        } else {
            this.regionGroupCacheMap.forEach((consensusGroupId, regionGroupCache) -> {
                int leaderDataNodeId = regionGroupCache.getLeaderDataNodeId();
                if (this.configManager.getNodeManager().isNodeRemoving(leaderDataNodeId)) {
                    result.put((TConsensusGroupId)consensusGroupId, -1);
                } else {
                    result.put((TConsensusGroupId)consensusGroupId, leaderDataNodeId);
                }
            });
        }
        return result;
    }

    public List<TRegionReplicaSet> filterRegionGroupThroughStatus(String storageGroup, RegionGroupStatus ... status) {
        return this.getAllReplicaSets(storageGroup).stream().filter(regionReplicaSet -> {
            TConsensusGroupId regionGroupId = regionReplicaSet.getRegionId();
            return this.regionGroupCacheMap.containsKey(regionGroupId) && Arrays.stream(status).anyMatch(s -> s.equals((Object)this.regionGroupCacheMap.get(regionGroupId).getRegionGroupStatus()));
        }).collect(Collectors.toList());
    }

    public RegionStatus getRegionStatus(TConsensusGroupId consensusGroupId, int dataNodeId) {
        return this.regionGroupCacheMap.containsKey(consensusGroupId) ? this.regionGroupCacheMap.get(consensusGroupId).getRegionStatus(dataNodeId) : RegionStatus.Unknown;
    }

    public RegionGroupStatus getRegionGroupStatus(TConsensusGroupId consensusGroupId) {
        return this.regionGroupCacheMap.containsKey(consensusGroupId) ? this.regionGroupCacheMap.get(consensusGroupId).getRegionGroupStatus() : RegionGroupStatus.Disabled;
    }

    public void cacheHeartbeatSample(TConsensusGroupId regionGroupId, RegionHeartbeatSample regionHeartbeatSample) {
        this.regionGroupCacheMap.computeIfAbsent(regionGroupId, empty -> new RegionGroupCache(regionGroupId)).cacheHeartbeatSample(regionHeartbeatSample);
        this.regionGroupCacheMap.get(regionGroupId).updateRegionStatistics();
    }

    public ScheduledExecutorService getRegionMaintainer() {
        return this.regionMaintainer;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    private ProcedureManager getProcedureManager() {
        return this.configManager.getProcedureManager();
    }
}

