/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.node;

import java.util.LinkedList;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.node.NodeHeartbeatSample;

public class DataNodeHeartbeatCache
extends BaseNodeCache {
    private volatile long loadScore = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheHeartbeatSample(NodeHeartbeatSample newHeartbeatSample) {
        LinkedList linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (this.slidingWindow.size() == 0 || ((NodeHeartbeatSample)this.slidingWindow.getLast()).getSendTimestamp() < newHeartbeatSample.getSendTimestamp()) {
                this.slidingWindow.add(newHeartbeatSample);
            }
            if (this.slidingWindow.size() > 100) {
                this.slidingWindow.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateNodeStatus() {
        NodeHeartbeatSample lastSample = null;
        LinkedList linkedList = this.slidingWindow;
        synchronized (linkedList) {
            if (this.slidingWindow.size() > 0) {
                lastSample = (NodeHeartbeatSample)this.slidingWindow.getLast();
            }
        }
        long lastSendTime = lastSample == null ? 0L : lastSample.getSendTimestamp();
        this.loadScore = -lastSendTime;
        String originStatus = this.status.getStatus();
        if (System.currentTimeMillis() - lastSendTime > 20000L) {
            this.status = NodeStatus.Unknown;
        } else if (lastSample != null) {
            this.status = lastSample.getStatus();
        }
        return NodeStatus.isNormalStatus((NodeStatus)this.status) != NodeStatus.isNormalStatus((NodeStatus)NodeStatus.parse((String)originStatus));
    }

    @Override
    public long getLoadScore() {
        return NodeStatus.isNormalStatus((NodeStatus)this.status) ? this.loadScore : Long.MAX_VALUE;
    }
}

