/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionAllocator;

public class CopySetRegionAllocator
implements IRegionAllocator {
    private static final int maximumRandomNum = 10;
    private int maxId = 0;
    private int intersectionSize = 0;
    private final List<TDataNodeLocation> weightList = new ArrayList<TDataNodeLocation>();

    @Override
    public TRegionReplicaSet allocateRegion(List<TDataNodeConfiguration> targetDataNodes, List<TRegionReplicaSet> allocatedRegions, int replicationFactor, TConsensusGroupId consensusGroupId) {
        TRegionReplicaSet result = null;
        this.buildWeightList(targetDataNodes, allocatedRegions);
        boolean accepted = false;
        while (true) {
            for (int retry = 0; retry < 10; ++retry) {
                result = this.genWeightedRandomRegion(replicationFactor);
                if (!this.intersectionCheck(allocatedRegions, result)) continue;
                accepted = true;
                break;
            }
            if (accepted) break;
            ++this.intersectionSize;
        }
        result.setRegionId(consensusGroupId);
        return result;
    }

    private void buildWeightList(List<TDataNodeConfiguration> onlineDataNodes, List<TRegionReplicaSet> allocatedRegions) {
        this.weightList.clear();
        int maximumRegionNum = 0;
        HashMap<TDataNodeLocation, Integer> countMap = new HashMap<TDataNodeLocation, Integer>();
        for (TDataNodeConfiguration tDataNodeConfiguration : onlineDataNodes) {
            this.maxId = Math.max(this.maxId, tDataNodeConfiguration.getLocation().getDataNodeId());
            countMap.put(tDataNodeConfiguration.getLocation(), 0);
        }
        for (TRegionReplicaSet tRegionReplicaSet : allocatedRegions) {
            for (TDataNodeLocation dataNodeLocation : tRegionReplicaSet.getDataNodeLocations()) {
                countMap.computeIfPresent(dataNodeLocation, (dataNode, count) -> count + 1);
                maximumRegionNum = Math.max(maximumRegionNum, (Integer)countMap.get(dataNodeLocation));
            }
        }
        for (Map.Entry entry : countMap.entrySet()) {
            int weight = maximumRegionNum - (Integer)entry.getValue() + 1;
            for (int repeat = 0; repeat < weight; ++repeat) {
                this.weightList.add(((TDataNodeLocation)entry.getKey()).deepCopy());
            }
        }
    }

    private TRegionReplicaSet genWeightedRandomRegion(int replicationFactor) {
        HashSet<Integer> checkSet = new HashSet<Integer>();
        TRegionReplicaSet randomRegion = new TRegionReplicaSet();
        Collections.shuffle(this.weightList);
        for (TDataNodeLocation dataNodeLocation : this.weightList) {
            if (checkSet.contains(dataNodeLocation.getDataNodeId())) continue;
            checkSet.add(dataNodeLocation.getDataNodeId());
            randomRegion.addToDataNodeLocations(dataNodeLocation);
            if (randomRegion.getDataNodeLocationsSize() != replicationFactor) continue;
            break;
        }
        return randomRegion;
    }

    private boolean intersectionCheck(List<TRegionReplicaSet> allocatedRegions, TRegionReplicaSet newRegion) {
        BitSet newBit = new BitSet(this.maxId + 1);
        for (TDataNodeLocation dataNodeLocation : newRegion.getDataNodeLocations()) {
            newBit.set(dataNodeLocation.getDataNodeId());
        }
        for (TRegionReplicaSet allocatedRegion : allocatedRegions) {
            BitSet allocatedBit = new BitSet(this.maxId + 1);
            for (TDataNodeLocation dataNodeLocation : allocatedRegion.getDataNodeLocations()) {
                allocatedBit.set(dataNodeLocation.getDataNodeId());
            }
            allocatedBit.and(newBit);
            if (allocatedBit.cardinality() <= this.intersectionSize) continue;
            return false;
        }
        return true;
    }
}

