/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.persistence.partition.RegionMaintainTask;

public class OfferRegionMaintainTasksPlan
extends ConfigPhysicalPlan {
    protected List<RegionMaintainTask> regionMaintainTaskList = new Vector<RegionMaintainTask>();

    public OfferRegionMaintainTasksPlan() {
        super(ConfigPhysicalPlanType.OfferRegionMaintainTasks);
    }

    public void appendRegionMaintainTask(RegionMaintainTask task) {
        this.regionMaintainTaskList.add(task);
    }

    public List<RegionMaintainTask> getRegionMaintainTaskList() {
        return this.regionMaintainTaskList;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(ConfigPhysicalPlanType.OfferRegionMaintainTasks.ordinal());
        stream.writeInt(this.regionMaintainTaskList.size());
        for (RegionMaintainTask task : this.regionMaintainTaskList) {
            task.serialize(stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            RegionMaintainTask task = RegionMaintainTask.Factory.create(buffer);
            this.regionMaintainTaskList.add(task);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferRegionMaintainTasksPlan that = (OfferRegionMaintainTasksPlan)o;
        return this.regionMaintainTaskList.equals(that.regionMaintainTaskList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.regionMaintainTaskList);
    }
}

