/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeDescriptor.class);
    private final CommonDescriptor commonDescriptor = CommonDescriptor.getInstance();
    private final ConfigNodeConfig conf = new ConfigNodeConfig();

    private ConfigNodeDescriptor() {
        this.loadProps();
    }

    public ConfigNodeConfig getConf() {
        return this.conf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL getPropsUrl() {
        String urlString = System.getProperty("CONFIGNODE_CONF", null);
        if (urlString == null) {
            urlString = System.getProperty("CONFIGNODE_HOME", null);
            if (urlString == null) return null;
            urlString = urlString + File.separatorChar + "conf" + File.separatorChar + "iotdb-confignode.properties";
        } else if (!urlString.endsWith(".properties")) {
            urlString = urlString + File.separatorChar + "iotdb-confignode.properties";
        }
        if (!urlString.startsWith("file:") && !urlString.startsWith("classpath:")) {
            urlString = "file:" + urlString;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        URL url = this.getPropsUrl();
        if (url == null) {
            LOGGER.warn("Couldn't load the ConfigNode configuration from any of the known sources. Use default configuration.");
            return;
        }
        try (InputStream inputStream = url.openStream();){
            LOGGER.info("start reading ConfigNode conf file: {}", (Object)url);
            Properties properties = new Properties();
            properties.load(inputStream);
            this.conf.setInternalAddress(properties.getProperty("internal_address", this.conf.getInternalAddress()));
            this.conf.setInternalPort(Integer.parseInt(properties.getProperty("internal_port", String.valueOf(this.conf.getInternalPort()))));
            this.conf.setConsensusPort(Integer.parseInt(properties.getProperty("consensus_port", String.valueOf(this.conf.getConsensusPort()))));
            String targetConfigNodes = properties.getProperty("target_config_nodes", null);
            if (targetConfigNodes != null) {
                this.conf.setTargetConfigNode(NodeUrlUtils.parseTEndPointUrl((String)targetConfigNodes));
            }
            this.conf.setSeriesPartitionSlotNum(Integer.parseInt(properties.getProperty("series_partition_slot_num", String.valueOf(this.conf.getSeriesPartitionSlotNum()))));
            this.conf.setSeriesPartitionExecutorClass(properties.getProperty("series_partition_executor_class", this.conf.getSeriesPartitionExecutorClass()));
            this.conf.setConfigNodeConsensusProtocolClass(properties.getProperty("config_node_consensus_protocol_class", this.conf.getConfigNodeConsensusProtocolClass()));
            this.conf.setSchemaRegionConsensusProtocolClass(properties.getProperty("schema_region_consensus_protocol_class", this.conf.getSchemaRegionConsensusProtocolClass()));
            this.conf.setSchemaRegionPerDataNode(Double.parseDouble(properties.getProperty("schema_region_per_data_node", String.valueOf(this.conf.getSchemaRegionPerDataNode()))));
            this.conf.setDataRegionConsensusProtocolClass(properties.getProperty("data_region_consensus_protocol_class", this.conf.getDataRegionConsensusProtocolClass()));
            this.conf.setDataRegionPerProcessor(Double.parseDouble(properties.getProperty("data_region_per_processor", String.valueOf(this.conf.getDataRegionPerProcessor()))));
            try {
                this.conf.setRegionAllocateStrategy(RegionBalancer.RegionAllocateStrategy.valueOf(properties.getProperty("region_allocate_strategy", this.conf.getRegionAllocateStrategy().name())));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("The configured region allocate strategy does not exist, use the default: GREEDY!");
            }
            this.conf.setRpcAdvancedCompressionEnable(Boolean.parseBoolean(properties.getProperty("rpc_advanced_compression_enable", String.valueOf(this.conf.isRpcAdvancedCompressionEnable()))));
            this.conf.setRpcMaxConcurrentClientNum(Integer.parseInt(properties.getProperty("rpc_max_concurrent_client_num", String.valueOf(this.conf.getRpcMaxConcurrentClientNum()))));
            this.conf.setThriftDefaultBufferSize(Integer.parseInt(properties.getProperty("thrift_init_buffer_size", String.valueOf(this.conf.getThriftDefaultBufferSize()))));
            this.conf.setThriftMaxFrameSize(Integer.parseInt(properties.getProperty("thrift_max_frame_size", String.valueOf(this.conf.getThriftMaxFrameSize()))));
            this.conf.setSystemDir(properties.getProperty("system_dir", this.conf.getSystemDir()));
            this.conf.setConsensusDir(properties.getProperty("consensus_dir", this.conf.getConsensusDir()));
            this.conf.setUdfLibDir(properties.getProperty("udf_lib_dir", this.conf.getUdfLibDir()));
            this.conf.setTemporaryLibDir(properties.getProperty("temporary_lib_dir", this.conf.getTemporaryLibDir()));
            this.conf.setTriggerLibDir(properties.getProperty("trigger_lib_dir", this.conf.getTriggerLibDir()));
            this.conf.setTimePartitionInterval(Long.parseLong(properties.getProperty("time_partition_interval_for_routing", String.valueOf(this.conf.getTimePartitionInterval()))));
            this.conf.setSchemaReplicationFactor(Integer.parseInt(properties.getProperty("schema_replication_factor", String.valueOf(this.conf.getSchemaReplicationFactor()))));
            this.conf.setDataReplicationFactor(Integer.parseInt(properties.getProperty("data_replication_factor", String.valueOf(this.conf.getDataReplicationFactor()))));
            this.conf.setHeartbeatInterval(Long.parseLong(properties.getProperty("heartbeat_interval", String.valueOf(this.conf.getHeartbeatInterval()))));
            String routingPolicy = properties.getProperty("routing_policy", this.conf.getRoutingPolicy());
            if (!routingPolicy.equals("greedy") && !routingPolicy.equals("leader")) {
                throw new IOException(String.format("Unknown routing_policy: %s, please set to \"leader\" or \"greedy\"", routingPolicy));
            }
            this.conf.setRoutingPolicy(routingPolicy);
            String readConsistencyLevel = properties.getProperty("read_consistency_level", this.conf.getReadConsistencyLevel());
            if (!readConsistencyLevel.equals("strong") && !readConsistencyLevel.equals("weak")) {
                throw new IOException(String.format("Unknown read_consistency_level: %s, please set to \"strong\" or \"weak\"", readConsistencyLevel));
            }
            this.conf.setReadConsistencyLevel(readConsistencyLevel);
            this.commonDescriptor.loadCommonProps(properties);
            this.commonDescriptor.initCommonConfigDir(this.conf.getSystemDir());
            this.conf.setProcedureCompletedEvictTTL(Integer.parseInt(properties.getProperty("procedure_completed_evict_ttl", String.valueOf(this.conf.getProcedureCompletedEvictTTL()))));
            this.conf.setProcedureCompletedCleanInterval(Integer.parseInt(properties.getProperty("procedure_completed_clean_interval", String.valueOf(this.conf.getProcedureCompletedCleanInterval()))));
            this.conf.setProcedureCoreWorkerThreadsSize(Integer.parseInt(properties.getProperty("procedure_core_worker_thread_size", String.valueOf(this.conf.getProcedureCoreWorkerThreadsSize()))));
            this.loadRatisConsensusConfig(properties);
        }
        catch (IOException | BadNodeUrlException e) {
            LOGGER.warn("Couldn't load ConfigNode conf file, use default config", e);
        }
        finally {
            this.conf.updatePath();
            this.commonDescriptor.getConfig().updatePath(System.getProperty("CONFIGNODE_HOME", null));
            MetricConfigDescriptor.getInstance().getMetricConfig().updateRpcInstance(this.conf.getInternalAddress(), this.conf.getInternalPort());
        }
    }

    private void loadRatisConsensusConfig(Properties properties) {
        this.conf.setDataRegionRatisConsensusLogAppenderBufferSize(Long.parseLong(properties.getProperty("data_region_ratis_log_appender_buffer_size_max", String.valueOf(this.conf.getDataRegionRatisConsensusLogAppenderBufferSize()))));
        this.conf.setPartitionRegionRatisConsensusLogAppenderBufferSize(Long.parseLong(properties.getProperty("partition_region_ratis_log_appender_buffer_size_max", String.valueOf(this.conf.getPartitionRegionRatisConsensusLogAppenderBufferSize()))));
        this.conf.setSchemaRegionRatisConsensusLogAppenderBufferSize(Long.parseLong(properties.getProperty("schema_region_ratis_log_appender_buffer_size_max", String.valueOf(this.conf.getSchemaRegionRatisConsensusLogAppenderBufferSize()))));
        this.conf.setDataRegionRatisSnapshotTriggerThreshold(Long.parseLong(properties.getProperty("data_region_ratis_snapshot_trigger_threshold", String.valueOf(this.conf.getDataRegionRatisConsensusLogAppenderBufferSize()))));
        this.conf.setPartitionRegionRatisSnapshotTriggerThreshold(Long.parseLong(properties.getProperty("partition_region_ratis_snapshot_trigger_threshold", String.valueOf(this.conf.getPartitionRegionRatisSnapshotTriggerThreshold()))));
        this.conf.setSchemaRegionRatisSnapshotTriggerThreshold(Long.parseLong(properties.getProperty("schema_region_ratis_snapshot_trigger_threshold", String.valueOf(this.conf.getSchemaRegionRatisSnapshotTriggerThreshold()))));
        this.conf.setDataRegionRatisLogUnsafeFlushEnable(Boolean.parseBoolean(properties.getProperty("data_region_ratis_log_unsafe_flush_enable", String.valueOf(this.conf.isDataRegionRatisLogUnsafeFlushEnable()))));
        this.conf.setPartitionRegionRatisLogUnsafeFlushEnable(Boolean.parseBoolean(properties.getProperty("partition_region_ratis_log_unsafe_flush_enable", String.valueOf(this.conf.isPartitionRegionRatisLogUnsafeFlushEnable()))));
        this.conf.setSchemaRegionRatisLogUnsafeFlushEnable(Boolean.parseBoolean(properties.getProperty("schema_region_ratis_log_unsafe_flush_enable", String.valueOf(this.conf.isSchemaRegionRatisLogUnsafeFlushEnable()))));
        this.conf.setDataRegionRatisLogSegmentSizeMax(Long.parseLong(properties.getProperty("data_region_ratis_log_segment_size_max", String.valueOf(this.conf.getDataRegionRatisLogSegmentSizeMax()))));
        this.conf.setPartitionRegionRatisLogSegmentSizeMax(Long.parseLong(properties.getProperty("partition_region_ratis_log_segment_size_max", String.valueOf(this.conf.getPartitionRegionRatisLogSegmentSizeMax()))));
        this.conf.setSchemaRegionRatisLogSegmentSizeMax(Long.parseLong(properties.getProperty("schema_region_ratis_log_segment_size_max", String.valueOf(this.conf.getSchemaRegionRatisLogSegmentSizeMax()))));
        this.conf.setDataRegionRatisGrpcFlowControlWindow(Long.parseLong(properties.getProperty("data_region_ratis_grpc_flow_control_window", String.valueOf(this.conf.getDataRegionRatisGrpcFlowControlWindow()))));
        this.conf.setPartitionRegionRatisGrpcFlowControlWindow(Long.parseLong(properties.getProperty("partition_region_ratis_grpc_flow_control_window", String.valueOf(this.conf.getPartitionRegionRatisGrpcFlowControlWindow()))));
        this.conf.setSchemaRegionRatisGrpcFlowControlWindow(Long.parseLong(properties.getProperty("schema_region_ratis_grpc_flow_control_window", String.valueOf(this.conf.getSchemaRegionRatisGrpcFlowControlWindow()))));
        this.conf.setDataRegionRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("data_region_ratis_rpc_leader_election_timeout_min_ms", String.valueOf(this.conf.getDataRegionRatisRpcLeaderElectionTimeoutMinMs()))));
        this.conf.setPartitionRegionRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("partition_region_ratis_rpc_leader_election_timeout_min_ms", String.valueOf(this.conf.getPartitionRegionRatisRpcLeaderElectionTimeoutMinMs()))));
        this.conf.setSchemaRegionRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("schema_region_ratis_rpc_leader_election_timeout_min_ms", String.valueOf(this.conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMinMs()))));
        this.conf.setDataRegionRatisRpcLeaderElectionTimeoutMinMs(Long.parseLong(properties.getProperty("data_region_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(this.conf.getDataRegionRatisRpcLeaderElectionTimeoutMaxMs()))));
        this.conf.setPartitionRegionRatisRpcLeaderElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("partition_region_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(this.conf.getPartitionRegionRatisRpcLeaderElectionTimeoutMaxMs()))));
        this.conf.setSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs(Long.parseLong(properties.getProperty("schema_region_ratis_rpc_leader_election_timeout_max_ms", String.valueOf(this.conf.getSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs()))));
    }

    public boolean isSeedConfigNode() {
        return (this.conf.getInternalAddress().equals(this.conf.getTargetConfigNode().getIp()) || NodeUrlUtils.isLocalAddress((String)this.conf.getInternalAddress()) && NodeUrlUtils.isLocalAddress((String)this.conf.getTargetConfigNode().getIp())) && this.conf.getInternalPort() == this.conf.getTargetConfigNode().getPort();
    }

    public static ConfigNodeDescriptor getInstance() {
        return ConfigNodeDescriptorHolder.INSTANCE;
    }

    private static class ConfigNodeDescriptorHolder {
        private static final ConfigNodeDescriptor INSTANCE = new ConfigNodeDescriptor();

        private ConfigNodeDescriptorHolder() {
        }
    }
}

