/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata.proxy;

import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.springdata.proxy.ClosableIgniteClientProxy;
import org.apache.ignite.springdata.proxy.ClosableIgniteNodeProxy;
import org.apache.ignite.springdata.proxy.IgniteCacheProxy;
import org.apache.ignite.springdata.proxy.IgniteClientProxy;
import org.apache.ignite.springdata.proxy.IgniteNodeProxy;

public interface IgniteProxy {
    public <K, V> IgniteCacheProxy<K, V> getOrCreateCache(String var1);

    public <K, V> IgniteCacheProxy<K, V> cache(String var1);

    public static IgniteProxy of(Object connObj) {
        if (connObj instanceof Ignite) {
            return new IgniteNodeProxy((Ignite)connObj);
        }
        if (connObj instanceof IgniteConfiguration) {
            try {
                return new IgniteNodeProxy(Ignition.ignite((String)((IgniteConfiguration)connObj).getIgniteInstanceName()));
            }
            catch (Exception exception) {
                return new ClosableIgniteNodeProxy(Ignition.start((IgniteConfiguration)((IgniteConfiguration)connObj)));
            }
        }
        if (connObj instanceof String) {
            return new ClosableIgniteNodeProxy(Ignition.start((String)((String)connObj)));
        }
        if (connObj instanceof IgniteClient) {
            return new IgniteClientProxy((IgniteClient)connObj);
        }
        if (connObj instanceof ClientConfiguration) {
            return new ClosableIgniteClientProxy(Ignition.startClient((ClientConfiguration)((ClientConfiguration)connObj)));
        }
        throw new IllegalArgumentException("Object of type " + connObj.getClass().getName() + " can not be used to connect to the Ignite cluster.");
    }
}

