/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteSpring;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.spring.AbstractCacheManager;
import org.apache.ignite.cache.spring.SpringCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.springdata.proxy.IgniteCacheProxy;
import org.apache.ignite.springdata.proxy.IgniteNodeCacheProxy;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class SpringCacheManager
extends AbstractCacheManager
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware,
DisposableBean {
    private static final int DEFAULT_LOCKS_COUNT = 512;
    private static final String SPRING_LOCK_NAME_PREFIX = "springSync";
    private String cfgPath;
    private IgniteConfiguration cfg;
    private String igniteInstanceName;
    private int locksCnt = 512;
    private CacheConfiguration<Object, Object> dynamicCacheCfg;
    private NearCacheConfiguration<Object, Object> dynamicNearCacheCfg;
    private Ignite ignite;
    private ApplicationContext springCtx;
    private ConcurrentHashMap<Integer, IgniteLock> locks = new ConcurrentHashMap();
    private boolean externalIgniteInstance;

    public void setApplicationContext(ApplicationContext ctx) {
        this.springCtx = ctx;
    }

    public String getConfigurationPath() {
        return this.cfgPath;
    }

    public void setConfigurationPath(String cfgPath) {
        this.cfgPath = cfgPath;
    }

    public IgniteConfiguration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(IgniteConfiguration cfg) {
        this.cfg = cfg;
    }

    @Deprecated
    public String getGridName() {
        return this.getIgniteInstanceName();
    }

    @Deprecated
    public void setGridName(String gridName) {
        this.setIgniteInstanceName(gridName);
    }

    public String getIgniteInstanceName() {
        return this.igniteInstanceName;
    }

    public void setIgniteInstanceName(String igniteInstanceName) {
        this.igniteInstanceName = igniteInstanceName;
    }

    public int getLocksCount() {
        return this.locksCnt;
    }

    public void setLocksCount(int locksCnt) {
        this.locksCnt = locksCnt;
    }

    public CacheConfiguration<Object, Object> getDynamicCacheConfiguration() {
        return this.dynamicCacheCfg;
    }

    public void setDynamicCacheConfiguration(CacheConfiguration<Object, Object> dynamicCacheCfg) {
        this.dynamicCacheCfg = dynamicCacheCfg;
    }

    public NearCacheConfiguration<Object, Object> getDynamicNearCacheConfiguration() {
        return this.dynamicNearCacheCfg;
    }

    public void setDynamicNearCacheConfiguration(NearCacheConfiguration<Object, Object> dynamicNearCacheCfg) {
        this.dynamicNearCacheCfg = dynamicNearCacheCfg;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.ignite == null) {
            if (this.cfgPath != null && this.cfg != null) {
                throw new IllegalArgumentException("Both 'configurationPath' and 'configuration' are provided. Set only one of these properties if you need to start a Ignite node inside of SpringCacheManager. If you already have a node running, omit both of them and set'igniteInstanceName' property.");
            }
            try {
                if (this.cfgPath != null) {
                    this.ignite = IgniteSpring.start((String)this.cfgPath, (ApplicationContext)this.springCtx);
                } else if (this.cfg != null) {
                    this.ignite = IgniteSpring.start((IgniteConfiguration)this.cfg, (ApplicationContext)this.springCtx);
                } else {
                    this.ignite = Ignition.ignite((String)this.igniteInstanceName);
                    this.externalIgniteInstance = true;
                }
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
        }
    }

    @Override
    protected SpringCache createCache(String name) {
        CacheConfiguration cacheCfg = this.dynamicCacheCfg != null ? new CacheConfiguration(this.dynamicCacheCfg) : new CacheConfiguration();
        NearCacheConfiguration nearCacheCfg = this.dynamicNearCacheCfg != null ? new NearCacheConfiguration(this.dynamicNearCacheCfg) : null;
        cacheCfg.setName(name);
        IgniteCache cache = nearCacheCfg != null ? this.ignite.getOrCreateCache(cacheCfg, nearCacheCfg) : this.ignite.getOrCreateCache(cacheCfg);
        return new SpringCache((IgniteCacheProxy<Object, Object>)new IgniteNodeCacheProxy(cache), this);
    }

    protected IgniteLock getSyncLock(String name, Object key) {
        int hash = Objects.hash(name, key);
        int idx = hash % this.getLocksCount();
        return this.locks.computeIfAbsent(idx, i -> this.ignite.reentrantLock(SPRING_LOCK_NAME_PREFIX + idx, true, false, true));
    }

    public void destroy() {
        if (!this.externalIgniteInstance) {
            this.ignite.close();
        }
    }
}

