/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import java.util.concurrent.locks.Lock;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.spring.AbstractCacheManager;
import org.apache.ignite.cache.spring.SpringCache;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.springdata.proxy.IgniteCacheProxy;
import org.apache.ignite.springdata.proxy.IgniteClientCacheProxy;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class IgniteClientSpringCacheManager
extends AbstractCacheManager
implements DisposableBean,
ApplicationListener<ContextRefreshedEvent> {
    private IgniteClient cli;
    private ClientConfiguration cliCfg;
    private ClientCacheConfiguration dynamicCacheCfg;
    private boolean externalCliInstance;

    public IgniteClient getClientInstance() {
        return this.cli;
    }

    public IgniteClientSpringCacheManager setClientInstance(IgniteClient cli) {
        A.notNull((Object)cli, (String)"cli");
        this.cli = cli;
        this.externalCliInstance = true;
        return this;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.cliCfg;
    }

    public IgniteClientSpringCacheManager setClientConfiguration(ClientConfiguration cliCfg) {
        this.cliCfg = cliCfg;
        return this;
    }

    public ClientCacheConfiguration getDynamicCacheConfiguration() {
        return this.dynamicCacheCfg;
    }

    public IgniteClientSpringCacheManager setDynamicCacheConfiguration(ClientCacheConfiguration dynamicCacheCfg) {
        this.dynamicCacheCfg = dynamicCacheCfg;
        return this;
    }

    @Override
    protected SpringCache createCache(String name) {
        ClientCacheConfiguration ccfg = this.dynamicCacheCfg == null ? new ClientCacheConfiguration() : new ClientCacheConfiguration(this.dynamicCacheCfg);
        ClientCache cache = this.cli.getOrCreateCache(ccfg.setName(name));
        return new SpringCache((IgniteCacheProxy<Object, Object>)new IgniteClientCacheProxy(cache), this);
    }

    public void destroy() throws Exception {
        if (!this.externalCliInstance) {
            this.cli.close();
        }
    }

    @Override
    protected Lock getSyncLock(String cache, Object key) {
        throw new UnsupportedOperationException("Synchronous mode is not supported for the Ignite Spring Cache implementation that uses a thin client to connecting to an Ignite cluster.");
    }

    public void onApplicationEvent(ContextRefreshedEvent evt) {
        if (this.cli != null) {
            return;
        }
        if (this.cliCfg == null) {
            throw new IllegalArgumentException("Neither client instance nor client configuration is specified. Set the 'clientInstance' property if you already have an Ignite client instance running, or set the 'clientConfiguration' property if an Ignite client instance need to be started implicitly by the manager.");
        }
        this.cli = Ignition.startClient((ClientConfiguration)this.cliCfg);
    }
}

