/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.apache.ignite.cache.spring.SpringCache;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public abstract class AbstractCacheManager
implements CacheManager {
    private final Map<String, SpringCache> caches = new ConcurrentHashMap<String, SpringCache>();

    public Cache getCache(String name) {
        return this.caches.computeIfAbsent(name, k -> this.createCache(name));
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.caches.keySet());
    }

    protected abstract SpringCache createCache(String var1);

    protected abstract Lock getSyncLock(String var1, Object var2);
}

