/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.QueryRetryException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.QueryTable;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.H2IndexCostedBase;
import org.apache.ignite.internal.processors.query.h2.opt.H2TableScanIndex;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.TableStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatistics;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.Insert;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableType;
import org.h2.value.DataType;
import org.jetbrains.annotations.Nullable;

public class GridH2Table
extends TableBase {
    private static final ThreadLocal<Boolean> INSERT_HACK = new ThreadLocal();
    private static final long EXCLUSIVE_LOCK = -1L;
    private static final AtomicIntegerFieldUpdater<GridH2Table> rebuildFromHashInProgressFiledUpdater = AtomicIntegerFieldUpdater.newUpdater(GridH2Table.class, "rebuildFromHashInProgress");
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final double STATS_UPDATE_THRESHOLD = 0.1;
    private final GridCacheContextInfo cacheInfo;
    private final GridH2RowDescriptor desc;
    private final H2TableDescriptor tblDesc;
    private volatile ArrayList<Index> idxs;
    private volatile int pkIdxPos;
    private volatile int sysIdxsCnt;
    private final Map<String, H2IndexCostedBase> tmpIdxs = new HashMap<String, H2IndexCostedBase>();
    private final ReentrantReadWriteLock lock;
    private volatile boolean destroyed;
    private final ConcurrentMap<Session, SessionLock> sessions = new ConcurrentHashMap<Session, SessionLock>();
    private final IndexColumn affKeyCol;
    private final boolean affKeyColIsKey;
    private final LongAdder size = new LongAdder();
    private volatile int rebuildFromHashInProgress = 0;
    private final QueryTable identifier;
    private final String identifierStr;
    private volatile Column[] safeColumns;
    private final AtomicLong ver = new AtomicLong();
    private volatile TableStatistics tblStats;
    @GridToStringExclude
    private IgniteLogger log;

    public GridH2Table(CreateTableData createTblData, GridH2RowDescriptor desc, H2TableDescriptor tblDesc, GridCacheContextInfo<?, ?> cacheInfo) {
        super(createTblData);
        assert (tblDesc != null);
        this.desc = desc;
        this.tblDesc = tblDesc;
        this.cacheInfo = cacheInfo;
        this.affKeyCol = this.calculateAffinityKeyColumn();
        this.affKeyColIsKey = this.affKeyCol != null && desc.isKeyColumn(this.affKeyCol.column.getColumnId());
        this.identifier = new QueryTable(this.getSchema().getName(), this.getName());
        this.identifierStr = this.identifier.schema() + "." + this.identifier.table();
        tblDesc.createHashIndex(this);
        tblDesc.createTextIndex(this);
        this.idxs = new ArrayList();
        if (tblDesc.hashIndex() != null) {
            this.idxs.add(tblDesc.hashIndex());
        }
        this.sysIdxsCnt = this.idxs.size();
        this.lock = new ReentrantReadWriteLock();
        if (cacheInfo.affinityNode()) {
            long totalTblSize = this.cacheSize(CachePeekMode.PRIMARY, CachePeekMode.BACKUP);
            this.size.add(totalTblSize);
        }
        this.tblStats = new TableStatistics(10000L, 10000L);
        if (desc != null && desc.context() != null) {
            GridKernalContext ctx = desc.context().kernalContext();
            this.log = ctx.log(((Object)((Object)this)).getClass());
        }
    }

    public void addSystemIndex(Index idx) {
        this.lock(true);
        try {
            if (idx.getIndexType().isPrimaryKey()) {
                this.idxs.add(0, (Index)new H2TableScanIndex(this, (GridH2IndexBase)idx, (GridH2IndexBase)this.tblDesc.hashIndex()));
                this.pkIdxPos = this.idxs.size();
            }
            this.idxs.add(idx);
            this.sysIdxsCnt = this.idxs.size();
        }
        finally {
            this.unlock(true);
        }
    }

    private IndexColumn calculateAffinityKeyColumn() {
        if (this.desc.type().customAffinityKeyMapper()) {
            return null;
        }
        String affKeyFieldName = this.desc.type().affinityKey();
        if (affKeyFieldName == null) {
            return this.indexColumn(0, 0);
        }
        if (!this.doesColumnExist(affKeyFieldName)) {
            return null;
        }
        int colId = this.getColumn(affKeyFieldName).getColumnId();
        if (this.desc.isKeyColumn(colId)) {
            return this.indexColumn(0, 0);
        }
        return this.indexColumn(colId, 0);
    }

    public boolean isPartitioned() {
        return this.desc != null && this.cacheInfo.config().getCacheMode() == CacheMode.PARTITIONED;
    }

    @Nullable
    public IndexColumn getAffinityKeyColumn() {
        return this.affKeyCol;
    }

    @Nullable
    public IndexColumn getExplicitAffinityKeyColumn() {
        if (this.affKeyCol == null || this.affKeyColIsKey) {
            return null;
        }
        return this.affKeyCol;
    }

    public boolean isColumnForPartitionPruning(Column col) {
        return this.isColumnForPartitionPruning0(col, false);
    }

    public boolean isColumnForPartitionPruningStrict(Column col) {
        return this.isColumnForPartitionPruning0(col, true);
    }

    private boolean isColumnForPartitionPruning0(Column col, boolean strict) {
        if (this.affKeyCol == null) {
            return false;
        }
        int colId = col.getColumnId();
        if (colId == this.affKeyCol.column.getColumnId()) {
            return true;
        }
        return (this.affKeyColIsKey || !strict) && this.desc.isKeyColumn(colId);
    }

    public boolean isCustomAffinityMapper() {
        return this.desc.type().customAffinityKeyMapper();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public GridH2RowDescriptor rowDescriptor() {
        return this.desc;
    }

    public H2TableDescriptor tableDescriptor() {
        return this.tblDesc;
    }

    public String cacheName() {
        return this.cacheInfo.name();
    }

    public int cacheId() {
        return this.cacheInfo.cacheId();
    }

    public GridCacheContextInfo cacheInfo() {
        return this.cacheInfo;
    }

    public ObjectStatistics tableStatistics() {
        GridCacheContext cacheContext = this.cacheInfo.cacheContext();
        if (cacheContext == null) {
            return null;
        }
        return cacheContext.kernalContext().query().statsManager().getLocalStatistics(new StatisticsKey(this.identifier.schema(), this.identifier.table()));
    }

    @Nullable
    public GridCacheContext cacheContext() {
        return this.cacheInfo.cacheContext();
    }

    public boolean lock(Session ses, boolean exclusive, boolean force) {
        SessionLock sesLock = (SessionLock)this.sessions.get(ses);
        if (sesLock != null) {
            if (sesLock.isExclusive()) {
                return true;
            }
            if (this.ver.get() != sesLock.version()) {
                throw new QueryRetryException(this.getName());
            }
            return false;
        }
        this.lock(exclusive, true);
        if (this.destroyed) {
            this.unlock(exclusive);
            throw new IllegalStateException("Table " + this.identifierString() + " already destroyed.");
        }
        this.sessions.put(ses, exclusive ? SessionLock.exclusiveLock() : SessionLock.sharedLock(this.ver.longValue()));
        ses.addLock((Table)this);
        return false;
    }

    public void unlock(Session ses) {
        SessionLock sesLock = (SessionLock)this.sessions.remove(ses);
        if (sesLock.locked) {
            this.unlock(sesLock.isExclusive());
        }
    }

    private void readLockInternal(Session ses) {
        SessionLock sesLock = (SessionLock)this.sessions.get(ses);
        assert (sesLock != null && !sesLock.isExclusive()) : "Invalid table lock [name=" + this.getName() + ", lock=" + sesLock == null ? "null" : Long.valueOf(sesLock.ver + 93L);
        if (!sesLock.locked) {
            this.lock(false);
            sesLock.locked = true;
        }
    }

    private void unlockReadInternal(Session ses) {
        SessionLock sesLock = (SessionLock)this.sessions.get(ses);
        assert (sesLock != null && !sesLock.isExclusive()) : "Invalid table unlock [name=" + this.getName() + ", lock=" + sesLock == null ? "null" : Long.valueOf(sesLock.ver + 93L);
        if (sesLock.locked) {
            sesLock.locked = false;
            this.unlock(false);
        }
    }

    private void lock(boolean exclusive) {
        this.lock(exclusive, false);
    }

    private void lock(boolean exclusive, boolean interruptibly) {
        Lock l = exclusive ? this.lock.writeLock() : this.lock.readLock();
        try {
            if (!exclusive) {
                if (interruptibly) {
                    l.lockInterruptibly();
                } else {
                    l.lock();
                }
            } else {
                while (!l.tryLock(200L, TimeUnit.MILLISECONDS)) {
                    Thread.yield();
                }
                this.ver.incrementAndGet();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedException("Thread got interrupted while trying to acquire table lock.", e);
        }
    }

    private void unlock(boolean exclusive) {
        Lock l = exclusive ? this.lock.writeLock() : this.lock.readLock();
        l.unlock();
    }

    private void checkVersion(Session ses) {
        SessionLock sesLock = (SessionLock)this.sessions.get(ses);
        assert (sesLock != null && !sesLock.isExclusive()) : "Invalid table check version  [name=" + this.getName() + ", lock=" + sesLock.ver + ']';
        if (this.ver.longValue() != sesLock.version()) {
            throw new QueryRetryException(this.getName());
        }
    }

    public QueryTable identifier() {
        return this.identifier;
    }

    public String identifierString() {
        return this.identifierStr;
    }

    private void ensureNotDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Table " + this.identifierString() + " already destroyed.");
        }
    }

    public void close(Session ses) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildrenAndResources(Session ses) {
        this.lock(true);
        try {
            super.removeChildrenAndResources(ses);
            while (this.idxs.size() > this.sysIdxsCnt) {
                Index idx = this.idxs.get(this.sysIdxsCnt);
                if (idx.getName() == null || idx.getSchema().findIndex(ses, idx.getName()) != idx) continue;
                this.database.removeSchemaObject(ses, (SchemaObject)idx);
                this.destroyIndex(idx);
            }
            if (SysProperties.CHECK) {
                for (SchemaObject obj : this.database.getAllSchemaObjects(1)) {
                    Index idx = (Index)obj;
                    if (idx.getTable() != this) continue;
                    DbException.throwInternalError((String)("index not dropped: " + idx.getName()));
                }
            }
            this.database.removeMeta(ses, this.getId());
            this.invalidate();
        }
        finally {
            this.unlock(true);
        }
    }

    public void destroy() {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            this.destroyed = true;
            int len = this.idxs.size();
            for (int i = 1; i < len; ++i) {
                this.destroyIndex(this.idxs.get(i));
            }
        }
        finally {
            this.unlock(true);
        }
    }

    private void destroyIndex(Index idx) {
        if (idx instanceof GridH2IndexBase) {
            GridH2IndexBase h2idx = (GridH2IndexBase)idx;
            h2idx.destroy();
        }
    }

    private <T extends Index> T index(int idx) {
        return (T)this.idxs.get(idx);
    }

    private GridH2IndexBase pk() {
        return (GridH2IndexBase)this.idxs.get(2);
    }

    public void update(CacheDataRow row, @Nullable CacheDataRow prevRow) {
        if (prevRow == null) {
            this.size.increment();
        }
    }

    public void remove(CacheDataRow row) {
        this.size.decrement();
    }

    public void markRebuildFromHashInProgress(boolean value) {
        assert (!value || this.idxs.size() >= 2 && this.index(1).getIndexType().isHash()) : "Table has no hash index.";
        if (rebuildFromHashInProgressFiledUpdater.compareAndSet(this, value ? 0 : 1, value ? 1 : 0)) {
            this.lock.writeLock().lock();
            try {
                this.incrementModificationCounter();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public boolean rebuildFromHashInProgress() {
        return this.rebuildFromHashInProgress == 1;
    }

    public Index addIndex(Session ses, String idxName, int idxId, IndexColumn[] cols, IndexType idxType, boolean create, String idxComment) {
        return this.commitUserIndex(ses, idxName);
    }

    @Nullable
    private Index checkIndexPresence(Index curIdx) throws IgniteCheckedException {
        IndexColumn[] curColumns = curIdx.getIndexColumns();
        Index registredIdx = null;
        for (Index idx : this.idxs) {
            if (F.eq((Object)curIdx.getName(), (Object)idx.getName())) {
                throw new IgniteCheckedException("Index already exists: " + idx.getName());
            }
            if (!(curIdx instanceof H2TreeIndex) || !(idx instanceof H2TreeIndex)) continue;
            IndexColumn[] idxColumns = idx.getIndexColumns();
            for (int i = 0; i < Math.min(idxColumns.length, curColumns.length); ++i) {
                IndexColumn idxCol = idxColumns[i];
                IndexColumn curCol = curColumns[i];
                if (curCol.column.getColumnId() == 0 && registredIdx != null) continue;
                if (H2Utils.equals(idxCol, curCol) && idxCol.sortType == curCol.sortType) {
                    registredIdx = idx;
                    continue;
                }
                registredIdx = null;
                break;
            }
            if (registredIdx == null) continue;
            return registredIdx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proposeUserIndex(Index idx) throws IgniteCheckedException {
        assert (idx instanceof H2IndexCostedBase);
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            Index idxExist = this.checkIndexPresence(idx);
            if (idxExist != null) {
                String idxCols = Stream.of(idxExist.getIndexColumns()).map(k -> k.columnName).collect(Collectors.joining(", "));
                U.warn((IgniteLogger)this.log, (Object)("Index with the given set or subset of columns already exists (consider dropping either new or existing index) [cacheName=" + this.cacheInfo.name() + ", schemaName=" + this.getSchema().getName() + ", tableName=" + this.getName() + ", newIndexName=" + idx.getName() + ", existingIndexName=" + idxExist.getName() + ", existingIndexColumns=[" + idxCols + "]]"));
            }
            Index oldTmpIdx = (Index)this.tmpIdxs.put(idx.getName(), (H2IndexCostedBase)idx);
            assert (oldTmpIdx == null);
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index commitUserIndex(Session ses, String idxName) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            Index idx = (Index)this.tmpIdxs.remove(idxName);
            assert (idx != null);
            ArrayList<Index> newIdxs = new ArrayList<Index>(this.idxs.size() + 1);
            newIdxs.addAll(this.idxs);
            newIdxs.add(idx);
            this.idxs = newIdxs;
            this.database.addSchemaObject(ses, (SchemaObject)idx);
            this.incrementModificationCounter();
            Index index = idx;
            return index;
        }
        finally {
            this.unlock(true);
        }
    }

    public void rollbackUserIndex(String idxName) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            H2IndexCostedBase rmvIdx = this.tmpIdxs.remove(idxName);
            assert (rmvIdx != null);
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(Index h2Idx) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            ArrayList<Index> idxs = new ArrayList<Index>(this.idxs);
            int i = this.pkIdxPos;
            while (i < idxs.size()) {
                Index idx = idxs.get(i);
                if (idx == h2Idx) {
                    idxs.remove(i);
                    if (!(idx instanceof GridH2IndexBase)) continue;
                    this.destroyIndex(idx);
                    continue;
                }
                ++i;
            }
            this.idxs = idxs;
        }
        finally {
            this.unlock(true);
        }
    }

    public void removeRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"removeRow");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public void addRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"addRow");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException((String)"alter");
    }

    public TableType getTableType() {
        return TableType.TABLE;
    }

    public Index getScanIndex(Session ses) {
        return this.getIndexes().get(0);
    }

    public Index getUniqueIndex() {
        if (this.rebuildFromHashInProgress == 1) {
            return this.index(1);
        }
        return this.index(2);
    }

    public ArrayList<Index> getIndexes() {
        if (this.rebuildFromHashInProgress == 0) {
            return this.idxs;
        }
        ArrayList<Index> idxs = new ArrayList<Index>(2);
        idxs.add(this.idxs.get(0));
        idxs.add(this.idxs.get(1));
        return idxs;
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public boolean isLockedExclusivelyBy(Session ses) {
        return false;
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(@Nullable Session ses) {
        return this.getUniqueIndex().getRowCount(ses);
    }

    public long getRowCountApproximation() {
        if (!this.localQuery(QueryContext.threadLocal())) {
            return 10000L;
        }
        this.refreshStatsIfNeeded();
        return this.tblStats.localRowCount();
    }

    private boolean localQuery(QueryContext qctx) {
        assert (qctx != null);
        return qctx.local();
    }

    private void refreshStatsIfNeeded() {
        long curTotalRowCnt;
        TableStatistics stats = this.tblStats;
        long statsTotalRowCnt = stats.totalRowCount();
        if (GridH2Table.needRefreshStats(statsTotalRowCnt, curTotalRowCnt = this.size.sum()) && this.cacheInfo.affinityNode()) {
            CacheConfiguration ccfg = this.cacheContext().config();
            int backups = ccfg.getCacheMode() == CacheMode.REPLICATED ? 0 : this.cacheContext().config().getBackups();
            long localOwnerRowCnt = this.cacheSize(CachePeekMode.PRIMARY, CachePeekMode.BACKUP) / (long)(backups + 1);
            int owners = this.cacheContext().discovery().cacheNodes(this.cacheContext().name(), AffinityTopologyVersion.NONE).size();
            long totalRowCnt = (long)owners * localOwnerRowCnt;
            this.size.reset();
            this.size.add(totalRowCnt);
            this.tblStats = new TableStatistics(totalRowCnt, localOwnerRowCnt);
        }
    }

    private static boolean needRefreshStats(long statsRowCnt, long actualRowCnt) {
        double delta = U.safeAbs((long)(statsRowCnt - actualRowCnt));
        double relativeChange = delta / (double)(statsRowCnt + 1L);
        return relativeChange > 0.1;
    }

    private long cacheSize(CachePeekMode ... modes) {
        try {
            return this.cacheInfo.cacheContext().cache().localSize(modes);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public IndexColumn indexColumn(int col, int sorting) {
        IndexColumn res = new IndexColumn();
        res.column = this.getColumn(col);
        res.columnName = res.column.getName();
        res.sortType = sorting;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumns(List<QueryField> cols) {
        this.lock(true);
        try {
            Column[] safeColumns0 = this.safeColumns;
            int pos = safeColumns0.length;
            Column[] newCols = new Column[safeColumns0.length + cols.size()];
            System.arraycopy(safeColumns0, 0, newCols, 0, safeColumns0.length);
            for (QueryField col : cols) {
                if (this.doesColumnExist(col.name())) {
                    return;
                }
                try {
                    Column c = new Column(col.name(), DataType.getTypeFromClass(Class.forName(col.typeName())));
                    c.setNullable(col.isNullable());
                    newCols[pos++] = c;
                }
                catch (ClassNotFoundException e) {
                    throw new IgniteSQLException("H2 data type not found for class: " + col.typeName(), (Throwable)e);
                }
            }
            this.setColumns(newCols);
            this.desc.onMetadataUpdated();
            this.incrementModificationCounter();
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropColumns(List<String> cols) {
        this.lock(true);
        try {
            Column[] safeColumns0 = this.safeColumns;
            int size = safeColumns0.length;
            for (String name : cols) {
                if (!this.doesColumnExist(name)) {
                    return;
                }
                --size;
            }
            assert (size > 2);
            Column[] newCols = new Column[size];
            int dst = 0;
            for (int i = 0; i < safeColumns0.length; ++i) {
                Column column = safeColumns0[i];
                for (String name : cols) {
                    if (!F.eq((Object)name, (Object)column.getName())) continue;
                    column = null;
                    break;
                }
                if (column == null) continue;
                newCols[dst++] = column;
            }
            this.setColumns(newCols);
            this.desc.onMetadataUpdated();
            for (Index idx : this.getIndexes()) {
                if (!(idx instanceof GridH2IndexBase)) continue;
                ((GridH2IndexBase)idx).refreshColumnIds();
            }
            this.incrementModificationCounter();
        }
        finally {
            this.unlock(true);
        }
    }

    protected void setColumns(Column[] columns) {
        this.safeColumns = columns;
        super.setColumns(columns);
    }

    public Column[] getColumns() {
        StackTraceElement[] elems;
        StackTraceElement elem;
        Column[] safeColumns0 = this.safeColumns;
        Boolean insertHack = INSERT_HACK.get();
        if (insertHack != null && insertHack.booleanValue() && F.eq((Object)(elem = (elems = Thread.currentThread().getStackTrace())[2]).getClassName(), (Object)Insert.class.getName()) && F.eq((Object)elem.getMethodName(), (Object)"prepare")) {
            Column[] columns0 = new Column[safeColumns0.length - 2];
            System.arraycopy(safeColumns0, 2, columns0, 0, columns0.length);
            return columns0;
        }
        return safeColumns0;
    }

    private void incrementModificationCounter() {
        assert (this.lock.isWriteLockedByCurrentThread());
        this.setModified();
    }

    public static void insertHack(boolean val) {
        INSERT_HACK.set(val);
    }

    public static boolean insertHackRequired(String sql) {
        if (F.isEmpty((String)sql)) {
            return false;
        }
        int idxInsert = (sql = sql.toLowerCase()).indexOf("insert");
        if (idxInsert < 0) {
            return false;
        }
        int idxInto = sql.indexOf("into", idxInsert);
        return idxInto >= 0;
    }

    public static void unlockTables(Session s) {
        for (Table t : s.getLocks()) {
            if (!(t instanceof GridH2Table)) continue;
            ((GridH2Table)t).unlockReadInternal(s);
        }
    }

    public static void readLockTables(Session s) {
        for (Table t : s.getLocks()) {
            if (!(t instanceof GridH2Table)) continue;
            ((GridH2Table)t).readLockInternal(s);
        }
    }

    public static void checkTablesVersions(Session s) {
        for (Table t : s.getLocks()) {
            if (!(t instanceof GridH2Table)) continue;
            ((GridH2Table)t).checkVersion(s);
        }
    }

    private static class SessionLock {
        final long ver;
        boolean locked;

        private SessionLock(long ver) {
            this.ver = ver;
            this.locked = true;
        }

        static SessionLock sharedLock(long ver) {
            return new SessionLock(ver);
        }

        static SessionLock exclusiveLock() {
            return new SessionLock(-1L);
        }

        boolean isExclusive() {
            return this.ver == -1L;
        }

        long version() {
            return this.ver;
        }
    }
}

