/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.index;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowCompartorImpl;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyTypeRegistry;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.engine.SessionInterface;
import org.h2.message.DbException;
import org.h2.value.DataType;
import org.h2.value.Value;

public class H2RowComparator
extends IndexRowCompartorImpl {
    private final CacheObjectContext coctx;
    private final GridH2Table table;
    private final SessionInterface ses;

    public H2RowComparator(GridH2Table table, IndexKeyTypeSettings keyTypeSettings) {
        super(keyTypeSettings);
        this.table = table;
        this.coctx = table.rowDescriptor().context().cacheObjectContext();
        this.ses = table.rowDescriptor().indexing().connections().jdbcConnection().getSession();
    }

    public int compareKey(long pageAddr, int off, int maxSize, IndexKey key, int curType) {
        int cmp = super.compareKey(pageAddr, off, maxSize, key, curType);
        if (cmp != Integer.MIN_VALUE) {
            return cmp;
        }
        int objType = InlineIndexKeyTypeRegistry.get((IndexKey)key, (int)curType, (IndexKeyTypeSettings)this.keyTypeSettings).type();
        int highOrder = Value.getHigherOrder((int)curType, (int)objType);
        if (highOrder != objType && highOrder == curType) {
            Value va = DataType.convertToValue((SessionInterface)this.ses, (Object)key.key(), (int)highOrder);
            va = va.convertTo(highOrder);
            IndexKey objHighOrder = IndexKeyFactory.wrap((Object)va.getObject(), (int)highOrder, (CacheObjectValueContext)this.coctx, (IndexKeyTypeSettings)this.keyTypeSettings);
            InlineIndexKeyType highType = InlineIndexKeyTypeRegistry.get((IndexKey)objHighOrder, (int)highOrder, (IndexKeyTypeSettings)this.keyTypeSettings);
            return ((NullableInlineIndexKeyType)highType).compare0(pageAddr, off, objHighOrder);
        }
        return Integer.MIN_VALUE;
    }

    public int compareKey(IndexRow left, IndexRow right, int idx) throws IgniteCheckedException {
        int cmp = super.compareKey(left, right, idx);
        if (cmp != Integer.MIN_VALUE) {
            return cmp;
        }
        Object lobject = left.key(idx).key();
        Object robject = right.key(idx).key();
        int ltype = left.indexSearchRow() ? DataType.getTypeFromClass(lobject.getClass()) : ((IndexKeyDefinition)left.rowHandler().indexKeyDefinitions().get(idx)).idxType();
        int rtype = right.indexSearchRow() ? DataType.getTypeFromClass(robject.getClass()) : ((IndexKeyDefinition)right.rowHandler().indexKeyDefinitions().get(idx)).idxType();
        int c = this.compareValues(this.wrap(lobject, ltype), this.wrap(robject, rtype));
        return Integer.signum(c);
    }

    private Value wrap(Object val, int type) throws IgniteCheckedException {
        return H2Utils.wrap((CacheObjectValueContext)this.coctx, val, type);
    }

    public int compareValues(Value v1, Value v2) throws IgniteCheckedException {
        try {
            return v1 == v2 ? 0 : this.table.compareTypeSafe(v1, v2);
        }
        catch (DbException ex) {
            throw new IgniteCheckedException("Rows cannot be compared", (Throwable)ex);
        }
    }
}

