/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.GridCache;
import org.apache.ignite.cache.hibernate.GridHibernateAccessStrategyAdapter;
import org.apache.ignite.cache.hibernate.GridHibernateNonStrictAccessStrategy;
import org.apache.ignite.cache.hibernate.GridHibernateReadOnlyAccessStrategy;
import org.apache.ignite.cache.hibernate.GridHibernateReadWriteAccessStrategy;
import org.apache.ignite.cache.hibernate.GridHibernateRegion;
import org.apache.ignite.cache.hibernate.GridHibernateRegionFactory;
import org.apache.ignite.cache.hibernate.GridHibernateTransactionalAccessStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cache.spi.access.AccessType;

public class GridHibernateTransactionalDataRegion
extends GridHibernateRegion
implements TransactionalDataRegion {
    private final CacheDataDescription dataDesc;

    public GridHibernateTransactionalDataRegion(GridHibernateRegionFactory factory, String name, Ignite ignite, GridCache<Object, Object> cache, CacheDataDescription dataDesc) {
        super(factory, name, ignite, cache);
        this.dataDesc = dataDesc;
    }

    public boolean isTransactionAware() {
        return false;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.dataDesc;
    }

    protected GridHibernateAccessStrategyAdapter createAccessStrategy(AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                return new GridHibernateReadOnlyAccessStrategy(this.ignite, (GridCache<Object, Object>)this.cache);
            }
            case NONSTRICT_READ_WRITE: {
                return new GridHibernateNonStrictAccessStrategy(this.ignite, (GridCache<Object, Object>)this.cache, this.factory.threadLocalForCache(this.cache.name()));
            }
            case READ_WRITE: {
                if (this.cache.configuration().getAtomicityMode() != CacheAtomicityMode.TRANSACTIONAL) {
                    throw new CacheException("Hibernate READ-WRITE access strategy must have Ignite cache with 'TRANSACTIONAL' atomicity mode: " + this.cache.name());
                }
                return new GridHibernateReadWriteAccessStrategy(this.ignite, (GridCache<Object, Object>)this.cache, this.factory.threadLocalForCache(this.cache.name()));
            }
            case TRANSACTIONAL: {
                if (this.cache.configuration().getAtomicityMode() != CacheAtomicityMode.TRANSACTIONAL) {
                    throw new CacheException("Hibernate TRANSACTIONAL access strategy must have Ignite cache with 'TRANSACTIONAL' atomicity mode: " + this.cache.name());
                }
                if (this.cache.configuration().getTransactionManagerLookupClassName() == null) {
                    throw new CacheException("Hibernate TRANSACTIONAL access strategy must have Ignite cache with TransactionManagerLookup configured: " + this.cache.name());
                }
                return new GridHibernateTransactionalAccessStrategy(this.ignite, (GridCache<Object, Object>)this.cache);
            }
        }
        throw new IllegalArgumentException("Unknown Hibernate access type: " + accessType);
    }
}

