/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.GridCache;
import org.apache.ignite.cache.hibernate.GridHibernateAccessStrategyAdapter;
import org.apache.ignite.lang.IgnitePredicate;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.jetbrains.annotations.Nullable;

public class GridHibernateTransactionalAccessStrategy
extends GridHibernateAccessStrategyAdapter {
    public GridHibernateTransactionalAccessStrategy(Ignite ignite, GridCache<Object, Object> cache) {
        super(ignite, cache);
    }

    @Override
    @Nullable
    protected Object get(Object key) throws CacheException {
        try {
            return this.cache.get(key);
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void putFromLoad(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new IgnitePredicate[0]);
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected SoftLock lock(Object key) throws CacheException {
        return null;
    }

    @Override
    protected void unlock(Object key, SoftLock lock) throws CacheException {
    }

    @Override
    protected boolean update(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new IgnitePredicate[0]);
            return true;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected boolean afterUpdate(Object key, Object val, SoftLock lock) throws CacheException {
        return false;
    }

    @Override
    protected boolean insert(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new IgnitePredicate[0]);
            return true;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected boolean afterInsert(Object key, Object val) throws CacheException {
        return false;
    }

    @Override
    protected void remove(Object key) throws CacheException {
        try {
            this.cache.removex(key, new IgnitePredicate[0]);
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

