/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.GridCache;
import org.apache.ignite.cache.hibernate.GridHibernateCollectionRegion;
import org.apache.ignite.cache.hibernate.GridHibernateEntityRegion;
import org.apache.ignite.cache.hibernate.GridHibernateNaturalIdRegion;
import org.apache.ignite.cache.hibernate.GridHibernateQueryResultsRegion;
import org.apache.ignite.cache.hibernate.GridHibernateTimestampsRegion;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.util.typedef.G;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;

public class GridHibernateRegionFactory
implements RegionFactory {
    private static final long serialVersionUID = 0L;
    public static final String GRID_NAME_PROPERTY = "org.apache.ignite.hibernate.grid_name";
    public static final String DFLT_CACHE_NAME_PROPERTY = "org.apache.ignite.hibernate.default_cache";
    public static final String REGION_CACHE_PROPERTY = "org.apache.ignite.hibernate.region_cache.";
    public static final String DFLT_ACCESS_TYPE_PROPERTY = "org.apache.ignite.hibernate.default_access_type";
    public static final String GRID_CONFIG_PROPERTY = "org.apache.ignite.hibernate.grid_config";
    private Ignite ignite;
    private GridCache<Object, Object> dfltCache;
    private AccessType dfltAccessType;
    private final Map<String, String> regionCaches = new HashMap<String, String>();
    private final ThreadLocal threadLoc = new ThreadLocal();

    public void start(Settings settings, Properties props) throws CacheException {
        IgniteLogger log;
        String gridName = props.getProperty(GRID_NAME_PROPERTY);
        if (gridName != null) {
            this.ignite = G.ignite((String)gridName);
        } else {
            String gridCfg = props.getProperty(GRID_CONFIG_PROPERTY);
            if (gridCfg == null) {
                throw new CacheException("Either grid name or path to grid configuration must be specified.");
            }
            try {
                this.ignite = G.start((String)gridCfg);
            }
            catch (IgniteException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (this.ignite == null) {
            throw new CacheException("Grid '" + gridName + "' for hibernate L2 cache is not started.");
        }
        String accessType = props.getProperty(DFLT_ACCESS_TYPE_PROPERTY, AccessType.NONSTRICT_READ_WRITE.name());
        this.dfltAccessType = AccessType.valueOf((String)accessType);
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String key = prop.getKey().toString();
            if (!key.startsWith(REGION_CACHE_PROPERTY)) continue;
            String regionName = key.substring(REGION_CACHE_PROPERTY.length());
            String cacheName = prop.getValue().toString();
            if (((IgniteKernal)this.ignite).cache(cacheName) == null) {
                throw new CacheException("Cache '" + cacheName + "' specified for region '" + regionName + "' " + "is not configured.");
            }
            this.regionCaches.put(regionName, cacheName);
        }
        String dfltCacheName = props.getProperty(DFLT_CACHE_NAME_PROPERTY);
        if (dfltCacheName != null) {
            this.dfltCache = ((IgniteKernal)this.ignite).cache(dfltCacheName);
            if (this.dfltCache == null) {
                throw new CacheException("Cache specified as default is not configured: " + dfltCacheName);
            }
        }
        if ((log = this.ignite.log().getLogger(GridHibernateRegionFactory.class)).isDebugEnabled()) {
            log.debug("GridHibernateRegionFactory started [grid=" + gridName + ']');
        }
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public AccessType getDefaultAccessType() {
        return this.dfltAccessType;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties props, CacheDataDescription metadata) throws CacheException {
        return new GridHibernateEntityRegion(this, regionName, this.ignite, this.regionCache(regionName), metadata);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties props, CacheDataDescription metadata) throws CacheException {
        return new GridHibernateNaturalIdRegion(this, regionName, this.ignite, this.regionCache(regionName), metadata);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties props, CacheDataDescription metadata) throws CacheException {
        return new GridHibernateCollectionRegion(this, regionName, this.ignite, this.regionCache(regionName), metadata);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties props) throws CacheException {
        return new GridHibernateQueryResultsRegion(this, regionName, this.ignite, this.regionCache(regionName));
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties props) throws CacheException {
        return new GridHibernateTimestampsRegion(this, regionName, this.ignite, this.regionCache(regionName));
    }

    ThreadLocal threadLocalForCache(String cacheName) {
        return this.threadLoc;
    }

    private GridCache<Object, Object> regionCache(String regionName) throws CacheException {
        GridCache cache;
        String cacheName = this.regionCaches.get(regionName);
        if (cacheName == null) {
            if (this.dfltCache != null) {
                return this.dfltCache;
            }
            cacheName = regionName;
        }
        if ((cache = ((IgniteKernal)this.ignite).cache(cacheName)) == null) {
            throw new CacheException("Cache '" + cacheName + "' for region '" + regionName + "' is not configured.");
        }
        return cache;
    }
}

