/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.util.Set;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.GridCache;
import org.apache.ignite.cache.hibernate.GridHibernateAccessStrategyAdapter;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;

public class GridHibernateReadWriteAccessStrategy
extends GridHibernateAccessStrategyAdapter {
    private final ThreadLocal<TxContext> txCtx;

    protected GridHibernateReadWriteAccessStrategy(Ignite ignite, GridCache<Object, Object> cache, ThreadLocal txCtx) {
        super(ignite, cache);
        this.txCtx = txCtx;
    }

    @Override
    protected Object get(Object key) throws CacheException {
        try {
            return this.cache.get(key);
        }
        catch (IgniteCheckedException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void putFromLoad(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new IgnitePredicate[0]);
        }
        catch (IgniteCheckedException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected SoftLock lock(Object key) throws CacheException {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx == null) {
                ctx = new TxContext();
                this.txCtx.set(ctx);
            }
            this.lockKey(key);
            ctx.locked(key);
            return null;
        }
        catch (IgniteCheckedException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void unlock(Object key, SoftLock lock) throws CacheException {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.unlock(ctx, key);
            }
        }
        catch (IgniteCheckedException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected boolean update(Object key, Object val) throws CacheException {
        return false;
    }

    @Override
    protected boolean afterUpdate(Object key, Object val, SoftLock lock) throws CacheException {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.cache.putx(key, val, new IgnitePredicate[0]);
                this.unlock(ctx, key);
                return true;
            }
            return false;
        }
        catch (IgniteCheckedException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected boolean insert(Object key, Object val) throws CacheException {
        return false;
    }

    @Override
    protected boolean afterInsert(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new IgnitePredicate[0]);
            return true;
        }
        catch (IgniteCheckedException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void remove(Object key) throws CacheException {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.cache.removex(key, new IgnitePredicate[0]);
            }
        }
        catch (IgniteCheckedException e) {
            this.rollbackCurrentTx();
            throw new CacheException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(TxContext ctx, Object key) throws IgniteCheckedException {
        if (ctx.unlocked(key)) {
            this.txCtx.remove();
            Transaction tx = this.cache.tx();
            assert (tx != null);
            try {
                tx.commit();
            }
            finally {
                tx.close();
            }
            assert (this.cache.tx() == null);
        }
    }

    private void rollbackCurrentTx() {
        try {
            TxContext ctx = this.txCtx.get();
            if (ctx != null) {
                this.txCtx.remove();
                Transaction tx = this.cache.tx();
                if (tx != null) {
                    tx.rollback();
                }
            }
        }
        catch (IgniteException e) {
            this.log.error("Failed to rollback cache transaction.", (Throwable)e);
        }
    }

    private void lockKey(Object key) throws IgniteCheckedException {
        if (this.cache.tx() == null) {
            this.cache.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);
        }
        this.cache.get(key);
    }

    private static class TxContext {
        private Set<Object> locked = new GridLeanSet();

        private TxContext() {
        }

        void locked(Object key) {
            this.locked.add(key);
        }

        boolean unlocked(Object key) {
            this.locked.remove(key);
            return this.locked.isEmpty();
        }
    }
}

