/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.hibernate;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.GridCache;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.CacheProjection;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.jetbrains.annotations.Nullable;

public abstract class GridHibernateAccessStrategyAdapter {
    protected final GridCache<Object, Object> cache;
    protected final Ignite ignite;
    protected final IgniteLogger log;

    protected GridHibernateAccessStrategyAdapter(Ignite ignite, GridCache<Object, Object> cache) {
        this.cache = cache;
        this.ignite = ignite;
        this.log = ignite.log();
    }

    @Nullable
    protected Object get(Object key) throws CacheException {
        try {
            return this.cache.get(key);
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    protected void putFromLoad(Object key, Object val, boolean minimalPutOverride) throws CacheException {
        this.putFromLoad(key, val);
    }

    protected void putFromLoad(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new IgnitePredicate[0]);
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Nullable
    protected abstract SoftLock lock(Object var1) throws CacheException;

    protected abstract void unlock(Object var1, SoftLock var2) throws CacheException;

    protected abstract boolean update(Object var1, Object var2) throws CacheException;

    protected abstract boolean afterUpdate(Object var1, Object var2, SoftLock var3) throws CacheException;

    protected abstract boolean insert(Object var1, Object var2) throws CacheException;

    protected abstract boolean afterInsert(Object var1, Object var2) throws CacheException;

    protected abstract void remove(Object var1) throws CacheException;

    protected void evict(Object key) throws CacheException {
        GridHibernateAccessStrategyAdapter.evict(this.ignite, this.cache, key);
    }

    protected void evictAll() throws CacheException {
        GridHibernateAccessStrategyAdapter.evictAll(this.cache);
    }

    @Nullable
    protected SoftLock lockRegion() throws CacheException {
        return null;
    }

    protected void unlockRegion(SoftLock lock) throws CacheException {
    }

    protected final void removeAll() throws CacheException {
        this.evictAll();
    }

    static void evict(Ignite ignite, CacheProjection<Object, Object> cache, Object key) throws CacheException {
        try {
            ignite.compute(cache.gridProjection()).call((IgniteCallable)new ClearKeyCallable(key, cache.name()));
        }
        catch (IgniteException e) {
            throw new CacheException((Throwable)e);
        }
    }

    static void evictAll(CacheProjection<Object, Object> cache) throws CacheException {
        try {
            cache.clear();
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static class ClearKeyCallable
    implements IgniteCallable<Void>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ignite;
        private Object key;
        private String cacheName;

        public ClearKeyCallable() {
        }

        private ClearKeyCallable(Object key, String cacheName) {
            this.key = key;
            this.cacheName = cacheName;
        }

        public Void call() throws IgniteCheckedException {
            GridCache cache = ((IgniteKernal)this.ignite).cache(this.cacheName);
            assert (cache != null);
            cache.clearLocally(this.key);
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.key);
            U.writeString((DataOutput)out, (String)this.cacheName);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.key = in.readObject();
            this.cacheName = U.readString((DataInput)in);
        }
    }
}

