/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.ignite.internal.util.typedef.F;

public class HintUtils {
    private HintUtils() {
    }

    public static boolean containsDisabledRules(ImmutableList<RelHint> hints) {
        return hints.stream().anyMatch(h -> "DISABLE_RULE".equals(h.hintName) && !h.listOptions.isEmpty());
    }

    public static Set<String> disabledRules(ImmutableList<RelHint> hints) {
        if (F.isEmpty(hints)) {
            return Collections.emptySet();
        }
        return hints.stream().filter(h -> "DISABLE_RULE".equals(h.hintName)).flatMap(h -> h.listOptions.stream()).collect(Collectors.toSet());
    }

    public static boolean isExpandDistinctAggregate(LogicalAggregate rel) {
        return rel.getHints().stream().anyMatch(h -> "EXPAND_DISTINCT_AGG".equals(h.hintName)) && rel.getAggCallList().stream().anyMatch(AggregateCall::isDistinct);
    }
}

