/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.jetbrains.annotations.Nullable;

public class ConvertingClosableIterator<Row>
implements Iterator<List<?>>,
AutoCloseable {
    private final Iterator<Row> it;
    private final RowHandler<Row> rowHnd;
    @Nullable
    private final Function<Object, Object> fieldConverter;

    public ConvertingClosableIterator(Iterator<Row> it, ExecutionContext<Row> ectx, @Nullable Function<Object, Object> fieldConverter) {
        this.it = it;
        this.rowHnd = ectx.rowHandler();
        this.fieldConverter = fieldConverter;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public List<Object> next() {
        Row next = this.it.next();
        int rowSize = this.rowHnd.columnCount(next);
        ArrayList<Object> res = new ArrayList<Object>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            res.add(this.fieldConverter == null ? this.rowHnd.get(i, next) : this.fieldConverter.apply(this.rowHnd.get(i, next)));
        }
        return res;
    }

    @Override
    public void close() throws Exception {
        Commons.close(this.it);
    }
}

