/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.trait;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.metadata.AffinityService;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.trait.AffinityAdapter;
import org.apache.ignite.internal.processors.query.calcite.trait.AllNodes;
import org.apache.ignite.internal.processors.query.calcite.trait.Destination;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.Partitioned;
import org.apache.ignite.internal.processors.query.calcite.trait.RandomNode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class DistributionFunction {
    private String name;

    private DistributionFunction() {
    }

    public abstract RelDistribution.Type type();

    public final String name() {
        if (this.name != null) {
            return this.name;
        }
        this.name = this.name0().intern();
        return this.name;
    }

    public boolean affinity() {
        return false;
    }

    public boolean correlated() {
        return false;
    }

    public int cacheId() {
        return 0;
    }

    public Object identity() {
        return this.type().shortName;
    }

    abstract <Row> Destination<Row> destination(ExecutionContext<Row> var1, AffinityService var2, ColocationGroup var3, ImmutableIntList var4);

    protected String name0() {
        return this.type().shortName;
    }

    public final int hashCode() {
        return Objects.hashCode(this.name());
    }

    public final boolean equals(Object obj) {
        if (obj instanceof DistributionFunction) {
            return this.name() == ((DistributionFunction)obj).name();
        }
        return false;
    }

    public final String toString() {
        return this.name();
    }

    public static DistributionFunction any() {
        return AnyDistribution.INSTANCE;
    }

    public static DistributionFunction broadcast() {
        return BroadcastDistribution.INSTANCE;
    }

    public static DistributionFunction singleton() {
        return SingletonDistribution.INSTANCE;
    }

    public static DistributionFunction random() {
        return RandomDistribution.INSTANCE;
    }

    public static DistributionFunction hash() {
        return HashDistribution.INSTANCE;
    }

    public static DistributionFunction affinity(int cacheId, Object identity) {
        return new AffinityDistribution(cacheId, identity);
    }

    public static DistributionFunction correlated(CorrelationId corrId, IgniteDistribution delegate) {
        return new CorrelatedDistribution(corrId, delegate);
    }

    public static boolean satisfy(DistributionFunction f0, DistributionFunction f1) {
        if (f0 == f1 || f0.name() == f1.name()) {
            return true;
        }
        return f0 instanceof AffinityDistribution && f1 instanceof AffinityDistribution && Objects.equals(((AffinityDistribution)f0).identity(), ((AffinityDistribution)f1).identity());
    }

    public static final class CorrelatedDistribution
    extends DistributionFunction {
        private final CorrelationId corrId;
        private final IgniteDistribution target;

        private CorrelatedDistribution(CorrelationId corrId, IgniteDistribution target) {
            this.corrId = corrId;
            this.target = target;
            assert (target.getType() == RelDistribution.Type.HASH_DISTRIBUTED) : target.getType();
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.RANDOM_DISTRIBUTED;
        }

        @Override
        public <Row> Destination<Row> destination(ExecutionContext<Row> ctx, AffinityService affSrvc, ColocationGroup target, ImmutableIntList keys) {
            throw new AssertionError((Object)"Correlated distribution should be converted to delegate before using");
        }

        public CorrelationId correlationId() {
            return this.corrId;
        }

        public IgniteDistribution target() {
            return this.target;
        }

        @Override
        public boolean correlated() {
            return true;
        }

        @Override
        protected String name0() {
            return "correlated[corrId=" + this.corrId + ", target=" + this.target + ']';
        }
    }

    private static final class AffinityDistribution
    extends DistributionFunction {
        private final int cacheId;
        private final Object identity;

        public AffinityDistribution(int cacheId, Object identity) {
            this.cacheId = cacheId;
            this.identity = identity;
        }

        @Override
        public boolean affinity() {
            return true;
        }

        @Override
        public int cacheId() {
            return this.cacheId;
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.HASH_DISTRIBUTED;
        }

        @Override
        public <Row> Destination<Row> destination(ExecutionContext<Row> ctx, AffinityService affSrvc, ColocationGroup m, ImmutableIntList k) {
            assert (m != null && !F.isEmpty(m.assignments()) && k.size() == 1);
            List<List<UUID>> assignments = m.assignments();
            if (U.assertionsEnabled()) {
                for (List<UUID> assignment : assignments) {
                    assert (F.isEmpty(assignment) || assignment.size() == 1);
                }
            }
            AffinityAdapter<Row> affinity = new AffinityAdapter<Row>(affSrvc.affinity(this.cacheId), k.toIntArray(), ctx.rowHandler());
            return new Partitioned<Row>(assignments, affinity);
        }

        @Override
        public Object identity() {
            return this.identity;
        }

        @Override
        protected String name0() {
            return "affinity[identity=" + this.identity + ", cacheId=" + this.cacheId + ']';
        }
    }

    private static final class HashDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new HashDistribution();

        private HashDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.HASH_DISTRIBUTED;
        }

        @Override
        public <Row> Destination<Row> destination(ExecutionContext<Row> ctx, AffinityService affSrvc, ColocationGroup m, ImmutableIntList k) {
            assert (m != null && !F.isEmpty(m.assignments()) && !k.isEmpty());
            List<List<UUID>> assignments = m.assignments();
            if (U.assertionsEnabled()) {
                for (List<UUID> assignment : assignments) {
                    assert (F.isEmpty(assignment) || assignment.size() == 1);
                }
            }
            AffinityAdapter<Row> affinity = new AffinityAdapter<Row>(affSrvc.affinity(0), k.toIntArray(), ctx.rowHandler());
            return new Partitioned<Row>(assignments, affinity);
        }
    }

    private static final class SingletonDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new SingletonDistribution();

        private SingletonDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.SINGLETON;
        }

        @Override
        public <Row> Destination<Row> destination(ExecutionContext<Row> ctx, AffinityService affinityService, ColocationGroup m, ImmutableIntList k) {
            if (m == null || m.nodeIds() == null || m.nodeIds().size() != 1) {
                throw new AssertionError();
            }
            return new AllNodes(Collections.singletonList(Objects.requireNonNull(F.first(m.nodeIds()))));
        }
    }

    private static final class RandomDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new RandomDistribution();

        private RandomDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.RANDOM_DISTRIBUTED;
        }

        @Override
        public <Row> Destination<Row> destination(ExecutionContext<Row> ctx, AffinityService affinityService, ColocationGroup m, ImmutableIntList k) {
            assert (m != null && !F.isEmpty(m.nodeIds()));
            return new RandomNode(m.nodeIds());
        }
    }

    private static final class BroadcastDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new BroadcastDistribution();

        private BroadcastDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.BROADCAST_DISTRIBUTED;
        }

        @Override
        public <Row> Destination<Row> destination(ExecutionContext<Row> ctx, AffinityService affinityService, ColocationGroup m, ImmutableIntList k) {
            assert (m != null && !F.isEmpty(m.nodeIds()));
            return new AllNodes(m.nodeIds());
        }
    }

    private static final class AnyDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new AnyDistribution();

        private AnyDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.ANY;
        }

        @Override
        public <Row> Destination<Row> destination(ExecutionContext<Row> ctx, AffinityService affinityService, ColocationGroup m, ImmutableIntList k) {
            throw new AssertionError();
        }
    }
}

