/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyTypeRegistry;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.IndexFirstLastScan;
import org.apache.ignite.internal.processors.query.calcite.exec.IndexScan;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.jetbrains.annotations.Nullable;

public class CacheIndexImpl
implements IgniteIndex {
    private final RelCollation collation;
    private final String idxName;
    @Nullable
    private final Index idx;
    private final IgniteCacheTable tbl;

    public CacheIndexImpl(RelCollation collation, String name, @Nullable Index idx, IgniteCacheTable tbl) {
        this.collation = collation;
        this.idxName = name;
        this.idx = idx;
        this.tbl = tbl;
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    @Override
    public String name() {
        return this.idxName;
    }

    @Override
    public IgniteTable table() {
        return this.tbl;
    }

    public Index queryIndex() {
        return this.idx;
    }

    @Override
    public IgniteLogicalIndexScan toRel(RelOptCluster cluster, RelOptTable relOptTbl, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        return IgniteLogicalIndexScan.create(cluster, cluster.traitSet(), relOptTbl, this.idxName, proj, cond, requiredColumns);
    }

    @Override
    public <Row> Iterable<Row> scan(ExecutionContext<Row> execCtx, ColocationGroup group, Predicate<Row> filters, RangeIterable<Row> ranges, Function<Row, Row> rowTransformer, @Nullable ImmutableBitSet requiredColumns) {
        UUID localNodeId = execCtx.localNodeId();
        if (group.nodeIds().contains(localNodeId) && this.idx != null) {
            return new IndexScan<Row>(execCtx, this.tbl.descriptor(), (InlineIndex)this.idx.unwrap(InlineIndex.class), this.collation.getKeys(), group.partitions(localNodeId), filters, ranges, rowTransformer, requiredColumns);
        }
        return Collections.emptyList();
    }

    @Override
    public <Row> Iterable<Row> firstOrLast(boolean first, ExecutionContext<Row> ectx, ColocationGroup grp, @Nullable ImmutableBitSet requiredColumns) {
        UUID localNodeId = ectx.localNodeId();
        if (grp.nodeIds().contains(localNodeId) && this.idx != null) {
            return new IndexFirstLastScan<Row>(first, ectx, this.tbl.descriptor(), (InlineIndexImpl)this.idx.unwrap(InlineIndexImpl.class), this.collation.getKeys(), grp.partitions(localNodeId), requiredColumns);
        }
        return Collections.emptyList();
    }

    @Override
    public long count(ExecutionContext<?> ectx, ColocationGroup grp, boolean notNull) {
        long cnt = 0L;
        if (this.idx != null && grp.nodeIds().contains(ectx.localNodeId())) {
            boolean checkExpired;
            IndexingQueryFilterImpl filter = new IndexingQueryFilterImpl(this.tbl.descriptor().cacheContext().kernalContext(), ectx.topologyVersion(), grp.partitions(ectx.localNodeId()));
            InlineIndex iidx = (InlineIndex)this.idx.unwrap(InlineIndex.class);
            BPlusTree.TreeRowClosure<IndexRow, IndexRow> rowFilter = null;
            boolean bl = checkExpired = !this.tbl.descriptor().cacheContext().config().isEagerTtl();
            if (notNull) {
                final boolean nullsFirst = ((RelFieldCollation)this.collation.getFieldCollations().get((int)0)).nullDirection == RelFieldCollation.NullDirection.FIRST;
                final BPlusTree.TreeRowClosure<IndexRow, IndexRow> notNullRowFilter = IndexScan.createNotNullRowFilter(iidx, checkExpired);
                final AtomicBoolean skipCheck = new AtomicBoolean();
                rowFilter = new BPlusTree.TreeRowClosure<IndexRow, IndexRow>(){

                    public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
                        if (skipCheck.get() && !checkExpired) {
                            return nullsFirst;
                        }
                        boolean res = notNullRowFilter.apply(tree, io, pageAddr, idx);
                        if (res == nullsFirst) {
                            skipCheck.set(true);
                        }
                        return res;
                    }
                };
            } else if (checkExpired) {
                rowFilter = IndexScan.createNotExpiredRowFilter();
            }
            try {
                for (int i = 0; i < iidx.segmentsCount(); ++i) {
                    cnt += iidx.count(i, new IndexQueryContext((IndexingQueryFilter)filter, rowFilter, ectx.mvccSnapshot()));
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Unable to count index records.", (Throwable)e);
            }
        }
        return cnt;
    }

    @Override
    public List<SearchBounds> toSearchBounds(RelOptCluster cluster, @Nullable RexNode cond, @Nullable ImmutableBitSet requiredColumns) {
        RelCollation collation = this.collation;
        RelDataType rowType = this.tbl.getRowType(cluster.getTypeFactory());
        if (requiredColumns != null) {
            collation = (RelCollation)collation.apply(Commons.mapping(requiredColumns, rowType.getFieldCount()));
        }
        if (!collation.getFieldCollations().isEmpty()) {
            return RexUtils.buildSortedSearchBounds(cluster, collation, cond, rowType, requiredColumns);
        }
        return null;
    }

    @Override
    public boolean isInlineScanPossible(@Nullable ImmutableBitSet requiredColumns) {
        ImmutableIntList idxKeys;
        if (this.idx == null) {
            return false;
        }
        if (this.tbl.descriptor().cacheInfo() != null && !this.tbl.descriptor().cacheInfo().config().isEagerTtl()) {
            return false;
        }
        if (requiredColumns == null) {
            requiredColumns = ImmutableBitSet.range((int)this.tbl.descriptor().columnDescriptors().size());
        }
        if ((idxKeys = this.collation.getKeys()).size() < requiredColumns.cardinality() || !ImmutableBitSet.of((ImmutableIntList)idxKeys).contains(requiredColumns)) {
            return false;
        }
        ArrayList keyDefs = new ArrayList(((InlineIndex)this.idx.unwrap(InlineIndex.class)).indexDefinition().indexKeyDefinitions().values());
        for (InlineIndexKeyType keyType : InlineIndexKeyTypeRegistry.types(keyDefs, (IndexKeyTypeSettings)new IndexKeyTypeSettings())) {
            if (keyType.keySize() >= 0 && keyType.type() != IndexKeyType.JAVA_OBJECT) continue;
            return false;
        }
        return true;
    }
}

